/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.AndCondition;
import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.ContainsCondition;
import io.deephaven.proto.backplane.grpc.InCondition;
import io.deephaven.proto.backplane.grpc.InvokeCondition;
import io.deephaven.proto.backplane.grpc.IsNullCondition;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.MatchesCondition;
import io.deephaven.proto.backplane.grpc.NotCondition;
import io.deephaven.proto.backplane.grpc.OrCondition;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.SearchCondition;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NormalizeFilterUtil {
    private static List<Condition> visitChildren(List<Condition> children, FilterVisitor<Condition> visitor) {
        return children.stream().map(c -> (Condition)FilterVisitor.accept(c, visitor)).collect(Collectors.toList());
    }

    public static Condition doAnd(List<Condition> filtersList) {
        return Condition.newBuilder().setAnd(AndCondition.newBuilder().addAllFilters(filtersList).build()).build();
    }

    public static Condition doAnd(List<Condition> filtersList, FilterVisitor<Condition> visitor) {
        return NormalizeFilterUtil.doAnd(NormalizeFilterUtil.visitChildren(filtersList, visitor));
    }

    public static Condition doOr(List<Condition> filtersList) {
        return Condition.newBuilder().setOr(OrCondition.newBuilder().addAllFilters(filtersList).build()).build();
    }

    public static Condition doOr(List<Condition> filtersList, FilterVisitor<Condition> visitor) {
        return NormalizeFilterUtil.doOr(NormalizeFilterUtil.visitChildren(filtersList, visitor));
    }

    public static Condition doInvert(Condition condition) {
        return Condition.newBuilder().setNot(NotCondition.newBuilder().setFilter(condition)).build();
    }

    public static Condition doInvert(Condition condition, FilterVisitor<Condition> visitor) {
        return NormalizeFilterUtil.doInvert(FilterVisitor.accept(condition, visitor));
    }

    public static Condition doNot(Condition filter, FilterVisitor<Condition> visitor) {
        Condition replacement = FilterVisitor.accept(filter, visitor);
        return Condition.newBuilder().setNot(NotCondition.newBuilder().setFilter(replacement).build()).build();
    }

    public static Condition doComparison(CompareCondition.CompareOperation operation, CaseSensitivity caseSensitivity, Value lhs, Value rhs) {
        return Condition.newBuilder().setCompare(CompareCondition.newBuilder().setOperation(operation).setCaseSensitivity(caseSensitivity).setLhs(lhs).setRhs(rhs).build()).build();
    }

    public static Condition doIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
        return Condition.newBuilder().setIn(InCondition.newBuilder().setTarget(target).addAllCandidates(candidatesList).setCaseSensitivity(caseSensitivity).setMatchType(matchType).build()).build();
    }

    public static Condition doIsNull(Reference reference) {
        return Condition.newBuilder().setIsNull(IsNullCondition.newBuilder().setReference(reference).build()).build();
    }

    public static Condition doInvoke(String method, @NotNull Value target, List<Value> argumentsList) {
        return Condition.newBuilder().setInvoke(InvokeCondition.newBuilder().setMethod(method).setTarget(target).addAllArguments(argumentsList).build()).build();
    }

    public static Condition doInvoke(String method, List<Value> argumentsList) {
        return Condition.newBuilder().setInvoke(InvokeCondition.newBuilder().setMethod(method).addAllArguments(argumentsList).build()).build();
    }

    public static Condition doContains(Reference reference, String searchString, CaseSensitivity caseSensitivity, MatchType matchType) {
        return Condition.newBuilder().setContains(ContainsCondition.newBuilder().setReference(reference).setSearchString(searchString).setCaseSensitivity(caseSensitivity).setMatchType(matchType).build()).build();
    }

    public static Condition doMatches(Reference reference, String regex, CaseSensitivity caseSensitivity, MatchType matchType) {
        return Condition.newBuilder().setMatches(MatchesCondition.newBuilder().setReference(reference).setRegex(regex).setCaseSensitivity(caseSensitivity).setMatchType(matchType).build()).build();
    }

    public static Condition doSearch(String searchString, List<Reference> optionalReferencesList) {
        return Condition.newBuilder().setSearch(SearchCondition.newBuilder().setSearchString(searchString).addAllOptionalReferences(optionalReferencesList).build()).build();
    }
}

