/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.server.table.ops.filter.AbstractNormalizeFilters;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class MergeNestedBinaryOperations
extends AbstractNormalizeFilters {
    private static final MergeNestedBinaryOperations INSTANCE = new MergeNestedBinaryOperations();

    public static Condition exec(Condition filter) {
        return FilterVisitor.accept(filter, INSTANCE);
    }

    @Override
    public Condition onAnd(List<Condition> filtersList) {
        ArrayList<Condition> visited = new ArrayList<Condition>();
        this.collect(filtersList, visited, Condition::hasAnd, c -> c.getAnd().getFiltersList());
        return NormalizeFilterUtil.doAnd(visited, this);
    }

    private void collect(List<Condition> filtersList, List<Condition> visited, Predicate<Condition> matches, Function<Condition, List<Condition>> getChildren) {
        for (Condition condition : filtersList) {
            if (matches.test(condition)) {
                this.collect(getChildren.apply(condition), visited, matches, getChildren);
                continue;
            }
            visited.add(condition);
        }
    }

    @Override
    public Condition onOr(List<Condition> filtersList) {
        ArrayList<Condition> visited = new ArrayList<Condition>();
        this.collect(filtersList, visited, Condition::hasOr, c -> c.getOr().getFiltersList());
        return NormalizeFilterUtil.doOr(visited, this);
    }
}

