/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.AbstractNormalizeFilters;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.util.Arrays;
import java.util.Collections;

public class MakeExpressionsNullSafe
extends AbstractNormalizeFilters {
    private static final MakeExpressionsNullSafe INSTANCE = new MakeExpressionsNullSafe();

    public static Condition exec(Condition filter) {
        return FilterVisitor.accept(filter, INSTANCE);
    }

    @Override
    public Condition onComparison(CompareCondition.CompareOperation operation, CaseSensitivity caseSensitivity, Value lhs, Value rhs) {
        if (caseSensitivity == CaseSensitivity.MATCH_CASE) {
            return super.onComparison(operation, caseSensitivity, lhs, rhs);
        }
        if (caseSensitivity != CaseSensitivity.IGNORE_CASE) {
            throw new IllegalStateException("Unrecognized case sensitivity " + String.valueOf(caseSensitivity));
        }
        Condition equalsIgnoreCase = NormalizeFilterUtil.doInvoke("equalsIgnoreCase", lhs, Collections.singletonList(rhs));
        if (lhs.hasLiteral()) {
            return equalsIgnoreCase;
        }
        Reference lhsRef = lhs.getReference();
        Condition lhsNullCheck = NormalizeFilterUtil.doAnd(Arrays.asList(NormalizeFilterUtil.doInvert(NormalizeFilterUtil.doIsNull(lhsRef)), equalsIgnoreCase));
        if (rhs.hasLiteral()) {
            return lhsNullCheck;
        }
        return NormalizeFilterUtil.doOr(Arrays.asList(NormalizeFilterUtil.doAnd(Arrays.asList(NormalizeFilterUtil.doIsNull(lhsRef), NormalizeFilterUtil.doIsNull(rhs.getReference()))), lhsNullCheck));
    }
}

