/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.AbstractNormalizeFilters;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlipNonReferenceMatchExpression
extends AbstractNormalizeFilters {
    private static final FlipNonReferenceMatchExpression INSTANCE = new FlipNonReferenceMatchExpression();

    public static Condition exec(Condition filter) {
        return FilterVisitor.accept(filter, INSTANCE);
    }

    @Override
    public Condition onIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
        boolean rewrite = target.hasLiteral();
        if (!rewrite) {
            for (Value candidate : candidatesList) {
                if (!candidate.hasReference()) continue;
                rewrite = true;
                break;
            }
        }
        if (!rewrite) {
            return NormalizeFilterUtil.doIn(target, candidatesList, caseSensitivity, matchType);
        }
        if (candidatesList.size() == 1) {
            return NormalizeFilterUtil.doIn(candidatesList.get(0), Collections.singletonList(target), caseSensitivity, matchType);
        }
        ArrayList<Condition> replacementChildren = new ArrayList<Condition>();
        for (Value candidate : candidatesList) {
            replacementChildren.add(NormalizeFilterUtil.doIn(candidate, Collections.singletonList(target), caseSensitivity, matchType));
        }
        switch (matchType) {
            case REGULAR: {
                return NormalizeFilterUtil.doOr(replacementChildren);
            }
            case INVERTED: {
                return NormalizeFilterUtil.doAnd(replacementChildren);
            }
        }
        throw new IllegalStateException("Unrecognized match type " + String.valueOf(matchType));
    }
}

