/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.Value;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface FilterVisitor<R> {
    public R onAnd(List<Condition> var1);

    public R onOr(List<Condition> var1);

    public R onNot(Condition var1);

    public R onComparison(CompareCondition.CompareOperation var1, CaseSensitivity var2, Value var3, Value var4);

    public R onIn(Value var1, List<Value> var2, CaseSensitivity var3, MatchType var4);

    public R onIsNull(Reference var1);

    public R onInvoke(String var1, @Nullable Value var2, List<Value> var3);

    public R onContains(Reference var1, String var2, CaseSensitivity var3, MatchType var4);

    public R onMatches(Reference var1, String var2, CaseSensitivity var3, MatchType var4);

    public R onSearch(String var1, List<Reference> var2);

    public static <R> R accept(Condition condition, FilterVisitor<R> visitor) {
        switch (condition.getDataCase()) {
            case AND: {
                return visitor.onAnd(condition.getAnd().getFiltersList());
            }
            case OR: {
                return visitor.onOr(condition.getOr().getFiltersList());
            }
            case NOT: {
                return visitor.onNot(condition.getNot().getFilter());
            }
            case COMPARE: {
                return visitor.onComparison(condition.getCompare().getOperation(), condition.getCompare().getCaseSensitivity(), condition.getCompare().getLhs(), condition.getCompare().getRhs());
            }
            case IN: {
                return visitor.onIn(condition.getIn().getTarget(), condition.getIn().getCandidatesList(), condition.getIn().getCaseSensitivity(), condition.getIn().getMatchType());
            }
            case INVOKE: {
                return visitor.onInvoke(condition.getInvoke().getMethod(), condition.getInvoke().hasTarget() ? condition.getInvoke().getTarget() : null, condition.getInvoke().getArgumentsList());
            }
            case IS_NULL: {
                return visitor.onIsNull(condition.getIsNull().getReference());
            }
            case MATCHES: {
                return visitor.onMatches(condition.getMatches().getReference(), condition.getMatches().getRegex(), condition.getMatches().getCaseSensitivity(), condition.getMatches().getMatchType());
            }
            case CONTAINS: {
                return visitor.onContains(condition.getContains().getReference(), condition.getContains().getSearchString(), condition.getContains().getCaseSensitivity(), condition.getContains().getMatchType());
            }
            case SEARCH: {
                return visitor.onSearch(condition.getSearch().getSearchString(), condition.getSearch().getOptionalReferencesList());
            }
        }
        throw new IllegalStateException("Unsupported condition " + String.valueOf(condition));
    }
}

