/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.Literal;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public class FilterPrinter
implements FilterVisitor<Void> {
    private final StringBuilder sb = new StringBuilder();
    private final boolean escapeStrings;

    public static String print(Condition condition) {
        FilterPrinter visitor = new FilterPrinter(true);
        FilterVisitor.accept(condition, visitor);
        return visitor.sb.toString();
    }

    public static String printNoEscape(Literal literal) {
        FilterPrinter visitor = new FilterPrinter(false);
        visitor.onLiteral(literal);
        return visitor.sb.toString();
    }

    public FilterPrinter(boolean escapeStrings) {
        this.escapeStrings = escapeStrings;
    }

    private String stringEscape(String str) {
        return "\"" + (this.escapeStrings ? StringEscapeUtils.escapeJava((String)str) : str) + "\"";
    }

    @Override
    public Void onAnd(List<Condition> filtersList) {
        if (filtersList.isEmpty()) {
            return null;
        }
        if (filtersList.size() == 1) {
            FilterVisitor.accept(filtersList.get(0), this);
            return null;
        }
        this.sb.append("(");
        FilterVisitor.accept(filtersList.get(0), this);
        filtersList.stream().skip(1L).forEach(condition -> {
            this.sb.append(" && ");
            FilterVisitor.accept(condition, this);
        });
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onOr(List<Condition> filtersList) {
        if (filtersList.isEmpty()) {
            return null;
        }
        if (filtersList.size() == 1) {
            FilterVisitor.accept(filtersList.get(0), this);
            return null;
        }
        this.sb.append("(");
        FilterVisitor.accept(filtersList.get(0), this);
        filtersList.stream().skip(1L).forEach(condition -> {
            this.sb.append(" || ");
            FilterVisitor.accept(condition, this);
        });
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onNot(Condition filter) {
        this.sb.append("!(");
        FilterVisitor.accept(filter, this);
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onComparison(CompareCondition.CompareOperation operation, CaseSensitivity caseSensitivity, Value lhs, Value rhs) {
        this.accept(lhs);
        switch (operation) {
            case LESS_THAN: {
                this.sb.append(" < ");
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                this.sb.append(" <= ");
                break;
            }
            case GREATER_THAN: {
                this.sb.append(" > ");
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                this.sb.append(" >= ");
                break;
            }
            case EQUALS: {
                this.sb.append(" == ");
                if (caseSensitivity != CaseSensitivity.IGNORE_CASE) break;
                this.sb.append("(ignore case)");
                break;
            }
            case NOT_EQUALS: {
                this.sb.append(" != ");
                if (caseSensitivity != CaseSensitivity.IGNORE_CASE) break;
                this.sb.append("(ignore case)");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation " + String.valueOf(operation));
            }
        }
        this.accept(rhs);
        return null;
    }

    @Override
    public Void onIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
        if (candidatesList.isEmpty()) {
            return null;
        }
        this.accept(target);
        if (caseSensitivity == CaseSensitivity.IGNORE_CASE) {
            this.sb.append(" icase");
        }
        if (matchType == MatchType.INVERTED) {
            this.sb.append(" not");
        }
        this.sb.append(" in ");
        this.accept(candidatesList.get(0));
        for (int i = 1; i < candidatesList.size(); ++i) {
            this.sb.append(", ");
            this.accept(candidatesList.get(i));
        }
        return null;
    }

    @Override
    public Void onIsNull(Reference reference) {
        this.sb.append("isNull(");
        this.onReference(reference);
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onInvoke(String method, @Nullable Value target, List<Value> argumentsList) {
        if (target != null) {
            this.accept(target);
            this.sb.append(".");
        }
        this.sb.append(method).append("(");
        for (int i = 0; i < argumentsList.size(); ++i) {
            if (i != 0) {
                this.sb.append(",");
            }
            this.accept(argumentsList.get(i));
        }
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onContains(Reference reference, String searchString, CaseSensitivity caseSensitivity, MatchType matchType) {
        if (matchType == MatchType.INVERTED) {
            this.sb.append("!");
        }
        this.sb.append("contains");
        if (caseSensitivity == CaseSensitivity.IGNORE_CASE) {
            this.sb.append("IgnoreCase");
        }
        this.sb.append("(");
        this.onReference(reference);
        this.sb.append(",");
        this.sb.append(this.stringEscape(searchString));
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onMatches(Reference reference, String regex, CaseSensitivity caseSensitivity, MatchType matchType) {
        if (matchType == MatchType.INVERTED) {
            this.sb.append("!");
        }
        this.sb.append("matches");
        if (caseSensitivity == CaseSensitivity.IGNORE_CASE) {
            this.sb.append("IgnoreCase");
        }
        this.sb.append("(");
        this.onReference(reference);
        this.sb.append(",");
        this.sb.append(this.stringEscape(regex));
        this.sb.append(")");
        return null;
    }

    @Override
    public Void onSearch(String searchString, List<Reference> optionalReferencesList) {
        this.sb.append("searchTableColumns(");
        this.sb.append(this.stringEscape(searchString));
        for (Reference reference : optionalReferencesList) {
            this.sb.append(",");
            this.onReference(reference);
        }
        this.sb.append(")");
        return null;
    }

    private void accept(Value value) {
        switch (value.getDataCase()) {
            case REFERENCE: {
                this.onReference(value.getReference());
                break;
            }
            case LITERAL: {
                this.onLiteral(value.getLiteral());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown value " + String.valueOf(value));
            }
        }
    }

    private void onReference(Reference reference) {
        this.sb.append(reference.getColumnName());
    }

    private void onLiteral(Literal literal) {
        switch (literal.getValueCase()) {
            case STRING_VALUE: {
                this.sb.append(this.stringEscape(literal.getStringValue()));
                break;
            }
            case DOUBLE_VALUE: {
                double doubleVal = literal.getDoubleValue();
                if (doubleVal == Double.NEGATIVE_INFINITY) {
                    this.sb.append("Double.NEGATIVE_INFINITY");
                    break;
                }
                if (doubleVal == Double.POSITIVE_INFINITY) {
                    this.sb.append("Double.POSITIVE_INFINITY");
                    break;
                }
                if (Double.isNaN(doubleVal)) {
                    this.sb.append("Double.NaN");
                    break;
                }
                long longVal = (long)doubleVal;
                if ((double)longVal - doubleVal != 0.0) {
                    this.sb.append(doubleVal);
                    break;
                }
                this.sb.append(longVal);
                break;
            }
            case BOOL_VALUE: {
                this.sb.append(literal.getBoolValue());
                break;
            }
            case LONG_VALUE: {
                this.sb.append(literal.getLongValue());
                break;
            }
            case NANO_TIME_VALUE: {
                this.sb.append("'").append(literal.getNanoTimeValue()).append("'");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown literal " + String.valueOf(literal));
            }
        }
    }
}

