/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.api.ColumnName;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterPattern;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.select.ConjunctiveFilter;
import io.deephaven.engine.table.impl.select.DisjunctiveFilter;
import io.deephaven.engine.table.impl.select.FormulaParserConfiguration;
import io.deephaven.engine.table.impl.select.MatchFilter;
import io.deephaven.engine.table.impl.select.RangeFilter;
import io.deephaven.engine.table.impl.select.WhereFilter;
import io.deephaven.engine.table.impl.select.WhereFilterFactory;
import io.deephaven.engine.table.impl.select.WhereNoneFilter;
import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.InvokeCondition;
import io.deephaven.proto.backplane.grpc.IsNullCondition;
import io.deephaven.proto.backplane.grpc.Literal;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.NotCondition;
import io.deephaven.proto.backplane.grpc.Reference;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.FilterPrinter;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterFactory
implements FilterVisitor<WhereFilter> {
    private final TableDefinition tableDefinition;

    private FilterFactory(@NotNull TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    public static WhereFilter makeFilter(TableDefinition tableDefinition, Condition condition) {
        FilterFactory f = new FilterFactory(tableDefinition);
        return FilterVisitor.accept(condition, f);
    }

    @Override
    public WhereFilter onAnd(List<Condition> filtersList) {
        WhereFilter[] items = (WhereFilter[])filtersList.stream().map(cond -> FilterVisitor.accept(cond, this)).toArray(WhereFilter[]::new);
        return ConjunctiveFilter.makeConjunctiveFilter((WhereFilter[])items);
    }

    @Override
    public WhereFilter onOr(List<Condition> filtersList) {
        WhereFilter[] items = (WhereFilter[])filtersList.stream().map(cond -> FilterVisitor.accept(cond, this)).toArray(WhereFilter[]::new);
        return DisjunctiveFilter.makeDisjunctiveFilter((WhereFilter[])items);
    }

    private WhereFilter generateConditionFilter(Condition filter) {
        return WhereFilterFactory.getExpression((String)FilterPrinter.print(filter));
    }

    @Override
    public WhereFilter onNot(Condition filter) {
        return this.generateConditionFilter(Condition.newBuilder().setNot(NotCondition.newBuilder().setFilter(filter).build()).build());
    }

    @Override
    public WhereFilter onComparison(CompareCondition.CompareOperation operation, CaseSensitivity caseSensitivity, Value lhs, Value rhs) {
        switch (operation) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.generateNumericConditionFilter(operation, lhs, rhs);
            }
            case EQUALS: 
            case NOT_EQUALS: {
                if (caseSensitivity != CaseSensitivity.MATCH_CASE) {
                    throw new IllegalStateException("Should have been compiled out in a previous pass");
                }
                return this.generateConditionFilter(NormalizeFilterUtil.doComparison(operation, caseSensitivity, lhs, rhs));
            }
        }
        throw new IllegalStateException("Can't handle compare operation " + String.valueOf(operation));
    }

    private WhereFilter generateNumericConditionFilter(CompareCondition.CompareOperation operation, Value lhs, Value rhs) {
        String valueString;
        String columName;
        Literal value;
        boolean invert;
        if (lhs.getDataCase() == Value.DataCase.LITERAL && rhs.getDataCase() == Value.DataCase.REFERENCE) {
            invert = true;
            value = lhs.getLiteral();
            columName = rhs.getReference().getColumnName();
        } else if (lhs.getDataCase() == Value.DataCase.REFERENCE && rhs.getDataCase() == Value.DataCase.LITERAL) {
            invert = false;
            columName = lhs.getReference().getColumnName();
            value = rhs.getLiteral();
        } else {
            return this.generateConditionFilter(Condition.newBuilder().setCompare(CompareCondition.newBuilder().setOperation(operation).setLhs(lhs).setRhs(rhs).build()).build());
        }
        switch (value.getValueCase()) {
            case STRING_VALUE: {
                valueString = value.getStringValue();
                break;
            }
            case DOUBLE_VALUE: {
                DecimalFormat format = new DecimalFormat("##0.################");
                format.setDecimalSeparatorAlwaysShown(false);
                format.setGroupingUsed(false);
                valueString = format.format(value.getDoubleValue());
                break;
            }
            case BOOL_VALUE: {
                valueString = Boolean.toString(value.getBoolValue());
                break;
            }
            case LONG_VALUE: {
                valueString = Long.toString(value.getLongValue());
                break;
            }
            case NANO_TIME_VALUE: {
                valueString = String.format("'%d'", value.getNanoTimeValue());
                break;
            }
            default: {
                throw new IllegalStateException("Range filter can't handle literal type " + String.valueOf(value.getValueCase()));
            }
        }
        return new RangeFilter(columName, this.rangeCondition(operation, invert), valueString, null, FormulaParserConfiguration.parser);
    }

    private io.deephaven.gui.table.filters.Condition rangeCondition(CompareCondition.CompareOperation operation, boolean invert) {
        switch (operation) {
            case LESS_THAN: {
                return invert ? io.deephaven.gui.table.filters.Condition.GREATER_THAN_OR_EQUAL : io.deephaven.gui.table.filters.Condition.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return invert ? io.deephaven.gui.table.filters.Condition.GREATER_THAN : io.deephaven.gui.table.filters.Condition.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return invert ? io.deephaven.gui.table.filters.Condition.LESS_THAN_OR_EQUAL : io.deephaven.gui.table.filters.Condition.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return invert ? io.deephaven.gui.table.filters.Condition.LESS_THAN : io.deephaven.gui.table.filters.Condition.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Can't handle compare operation " + String.valueOf(operation) + " in range operation");
    }

    @Override
    public WhereFilter onIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
        assert (target.getDataCase() == Value.DataCase.REFERENCE);
        Reference reference = target.getReference();
        String[] values = new String[candidatesList.size()];
        for (int i = 0; i < candidatesList.size(); ++i) {
            Value d = candidatesList.get(i);
            assert (d.getDataCase() == Value.DataCase.LITERAL);
            Literal literal = d.getLiteral();
            values[i] = literal.getValueCase() == Literal.ValueCase.NANO_TIME_VALUE ? String.format("'%d'", literal.getNanoTimeValue()) : FilterPrinter.printNoEscape(literal);
        }
        return new MatchFilter(this.caseSensitivity(caseSensitivity), this.matchType(matchType), reference.getColumnName(), values);
    }

    private MatchFilter.CaseSensitivity caseSensitivity(CaseSensitivity caseSensitivity) {
        switch (caseSensitivity) {
            case MATCH_CASE: {
                return MatchFilter.CaseSensitivity.MatchCase;
            }
            case IGNORE_CASE: {
                return MatchFilter.CaseSensitivity.IgnoreCase;
            }
        }
        throw new IllegalStateException("Can't handle compare case sensitivity " + String.valueOf(caseSensitivity));
    }

    private MatchFilter.MatchType matchType(MatchType matchType) {
        switch (matchType) {
            case REGULAR: {
                return MatchFilter.MatchType.Regular;
            }
            case INVERTED: {
                return MatchFilter.MatchType.Inverted;
            }
        }
        throw new IllegalStateException("Can't handle compare match type " + String.valueOf(matchType));
    }

    @Override
    public WhereFilter onIsNull(Reference reference) {
        return this.generateConditionFilter(Condition.newBuilder().setIsNull(IsNullCondition.newBuilder().setReference(reference).build()).build());
    }

    @Override
    public WhereFilter onInvoke(String method, @Nullable Value target, List<Value> argumentsList) {
        InvokeCondition.Builder partialInvoke = InvokeCondition.newBuilder().setMethod(method).addAllArguments(argumentsList);
        if (target != null) {
            partialInvoke.setTarget(target);
        }
        return this.generateConditionFilter(Condition.newBuilder().setInvoke(partialInvoke).build());
    }

    @Override
    public WhereFilter onContains(Reference reference, String searchString, CaseSensitivity caseSensitivity, MatchType matchType) {
        int flags = caseSensitivity == CaseSensitivity.IGNORE_CASE ? 2 : 0;
        return WhereFilter.of((Filter)FilterPattern.of((Expression)ColumnName.of((String)reference.getColumnName()), (Pattern)Pattern.compile(Pattern.quote(searchString), flags), (FilterPattern.Mode)FilterPattern.Mode.FIND, (matchType == MatchType.INVERTED ? 1 : 0) != 0));
    }

    @Override
    public WhereFilter onMatches(Reference reference, String regex, CaseSensitivity caseSensitivity, MatchType matchType) {
        int flags = (caseSensitivity == CaseSensitivity.IGNORE_CASE ? 2 : 0) | 0x20;
        return WhereFilter.of((Filter)FilterPattern.of((Expression)ColumnName.of((String)reference.getColumnName()), (Pattern)Pattern.compile(regex, flags), (FilterPattern.Mode)FilterPattern.Mode.MATCHES, (matchType == MatchType.INVERTED ? 1 : 0) != 0));
    }

    @Override
    public WhereFilter onSearch(String searchString, List<Reference> optionalReferencesList) {
        Set columnNames = optionalReferencesList.stream().map(Reference::getColumnName).collect(Collectors.toSet());
        WhereFilter[] whereFilters = WhereFilterFactory.expandQuickFilter((TableDefinition)this.tableDefinition, (String)searchString, columnNames);
        if (whereFilters.length == 0) {
            return WhereNoneFilter.INSTANCE;
        }
        return DisjunctiveFilter.makeDisjunctiveFilter((WhereFilter[])whereFilters);
    }
}

