/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops.filter;

import io.deephaven.proto.backplane.grpc.CaseSensitivity;
import io.deephaven.proto.backplane.grpc.CompareCondition;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.MatchType;
import io.deephaven.proto.backplane.grpc.Value;
import io.deephaven.server.table.ops.filter.AbstractNormalizeFilters;
import io.deephaven.server.table.ops.filter.FilterVisitor;
import io.deephaven.server.table.ops.filter.NormalizeFilterUtil;
import java.util.List;

public class ConvertInvalidInExpressions
extends AbstractNormalizeFilters {
    private static final ConvertInvalidInExpressions INSTANCE = new ConvertInvalidInExpressions();

    public static Condition exec(Condition filter) {
        return FilterVisitor.accept(filter, INSTANCE);
    }

    @Override
    public Condition onIn(Value target, List<Value> candidatesList, CaseSensitivity caseSensitivity, MatchType matchType) {
        if (candidatesList.size() != 1 || target.getDataCase() != candidatesList.get(0).getDataCase()) {
            return super.onIn(target, candidatesList, caseSensitivity, matchType);
        }
        return NormalizeFilterUtil.doComparison(this.operation(matchType), caseSensitivity, target, candidatesList.get(0));
    }

    private CompareCondition.CompareOperation operation(MatchType matchType) {
        switch (matchType) {
            case REGULAR: {
                return CompareCondition.CompareOperation.EQUALS;
            }
            case INVERTED: {
                return CompareCondition.CompareOperation.NOT_EQUALS;
            }
        }
        throw new IllegalStateException("Can't handle matchType" + String.valueOf(matchType));
    }
}

