/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import io.deephaven.api.JoinMatch;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.WhereInRequest;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WhereInGrpcImpl
extends GrpcTableOperation<WhereInRequest> {
    private static List<TableReference> refs(WhereInRequest request) {
        return List.of(request.getLeftId(), request.getRightId());
    }

    @Inject
    public WhereInGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionWhereIn(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getWhereIn, WhereInRequest::getResultId, WhereInGrpcImpl::refs);
    }

    @Override
    public final void validateRequest(WhereInRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)request, 5);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getLeftId());
        Common.validate(request.getRightId());
    }

    @Override
    public final Table create(WhereInRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)2);
        Assert.gtZero((int)request.getColumnsToMatchCount(), (String)"request.getColumnsToMatchCount()");
        Table left = sourceTables.get(0).get();
        Table right = sourceTables.get(1).get();
        List columnsToMatch = JoinMatch.from((Collection)request.getColumnsToMatchList());
        try (SafeCloseable ignored = this.lock(left, right);){
            Table table = request.getInverted() ? (Table)left.whereNotIn((Object)right, (Collection)columnsToMatch) : (Table)left.whereIn((Object)right, (Collection)columnsToMatch);
            return table;
        }
    }

    private SafeCloseable lock(Table left, Table right) {
        if (left.isRefreshing()) {
            return left.getUpdateGraph().sharedLock().lockCloseable();
        }
        if (right.isRefreshing()) {
            return right.getUpdateGraph().sharedLock().lockCloseable();
        }
        return null;
    }
}

