/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import io.deephaven.api.Selectable;
import io.deephaven.api.TableOperations;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.select.SelectColumn;
import io.deephaven.engine.table.impl.select.SelectColumnFactory;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SelectOrUpdateRequest;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

public abstract class UpdateOrSelectGrpcImpl
extends GrpcTableOperation<SelectOrUpdateRequest> {
    private final RealTableOperation realTableOperation;
    private final boolean requiresSharedLock;
    @NotNull
    private final ColumnExpressionValidator columnExpressionValidator;

    protected UpdateOrSelectGrpcImpl(GrpcTableOperation.PermissionFunction<SelectOrUpdateRequest> permission, Function<BatchTableRequest.Operation, SelectOrUpdateRequest> getRequest, RealTableOperation realTableOperation, boolean requiresSharedLock, @NotNull ColumnExpressionValidator columnExpressionValidator) {
        super(permission, getRequest, SelectOrUpdateRequest::getResultId, SelectOrUpdateRequest::getSourceId);
        this.realTableOperation = realTableOperation;
        this.requiresSharedLock = requiresSharedLock;
        this.columnExpressionValidator = columnExpressionValidator;
    }

    @Override
    public Table create(SelectOrUpdateRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        String[] columnSpecs = (String[])request.getColumnSpecsList().toArray(String[]::new);
        SelectColumn[] expressions = SelectColumnFactory.getExpressions((String[])columnSpecs);
        this.columnExpressionValidator.validateColumnExpressions(expressions, columnSpecs, parent);
        if (parent.isRefreshing() && this.requiresSharedLock) {
            UpdateGraph updateGraph = parent.getUpdateGraph();
            return (Table)updateGraph.sharedLock().computeLocked(() -> this.realTableOperation.apply(parent, Arrays.asList(expressions)));
        }
        return this.realTableOperation.apply(parent, Arrays.asList(expressions));
    }

    @FunctionalInterface
    protected static interface RealTableOperation {
        public Table apply(Table var1, Collection<? extends Selectable> var2);
    }

    @Singleton
    public static class SelectGrpcImpl
    extends UpdateOrSelectGrpcImpl {
        @Inject
        public SelectGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionSelect(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSelect, TableOperations::select, true, columnExpressionValidator);
        }
    }

    @Singleton
    public static class UpdateViewGrpcImpl
    extends UpdateOrSelectGrpcImpl {
        @Inject
        public UpdateViewGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionUpdateView(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getUpdateView, TableOperations::updateView, false, columnExpressionValidator);
        }
    }

    @Singleton
    public static class ViewGrpcImpl
    extends UpdateOrSelectGrpcImpl {
        @Inject
        public ViewGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionView(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getView, TableOperations::view, false, columnExpressionValidator);
        }
    }

    @Singleton
    public static class LazyUpdateGrpcImpl
    extends UpdateOrSelectGrpcImpl {
        @Inject
        public LazyUpdateGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionLazyUpdate(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getLazyUpdate, TableOperations::lazyUpdate, true, columnExpressionValidator);
        }
    }

    @Singleton
    public static class UpdateGrpcImpl
    extends UpdateOrSelectGrpcImpl {
        @Inject
        public UpdateGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionUpdate(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getUpdate, TableOperations::update, true, columnExpressionValidator);
        }
    }
}

