/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.Pair;
import io.deephaven.api.updateby.BadDataBehavior;
import io.deephaven.api.updateby.ColumnUpdateOperation;
import io.deephaven.api.updateby.DeltaControl;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.UpdateByControl;
import io.deephaven.api.updateby.UpdateByOperation;
import io.deephaven.api.updateby.spec.CumCountWhereSpec;
import io.deephaven.api.updateby.spec.CumMinMaxSpec;
import io.deephaven.api.updateby.spec.CumProdSpec;
import io.deephaven.api.updateby.spec.CumSumSpec;
import io.deephaven.api.updateby.spec.DeltaSpec;
import io.deephaven.api.updateby.spec.EmMinMaxSpec;
import io.deephaven.api.updateby.spec.EmStdSpec;
import io.deephaven.api.updateby.spec.EmaSpec;
import io.deephaven.api.updateby.spec.EmsSpec;
import io.deephaven.api.updateby.spec.FillBySpec;
import io.deephaven.api.updateby.spec.RollingAvgSpec;
import io.deephaven.api.updateby.spec.RollingCountSpec;
import io.deephaven.api.updateby.spec.RollingCountWhereSpec;
import io.deephaven.api.updateby.spec.RollingFormulaSpec;
import io.deephaven.api.updateby.spec.RollingGroupSpec;
import io.deephaven.api.updateby.spec.RollingMinMaxSpec;
import io.deephaven.api.updateby.spec.RollingProductSpec;
import io.deephaven.api.updateby.spec.RollingStdSpec;
import io.deephaven.api.updateby.spec.RollingSumSpec;
import io.deephaven.api.updateby.spec.RollingWAvgSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.MathContext;
import io.deephaven.proto.backplane.grpc.UpdateByDeltaOptions;
import io.deephaven.proto.backplane.grpc.UpdateByEmOptions;
import io.deephaven.proto.backplane.grpc.UpdateByRequest;
import io.deephaven.proto.backplane.grpc.UpdateByWindowScale;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.time.DateTimeUtils;
import io.grpc.StatusRuntimeException;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class UpdateByGrpcImpl
extends GrpcTableOperation<UpdateByRequest> {
    @Inject
    public UpdateByGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionUpdateBy(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getUpdateBy, UpdateByRequest::getResultId, UpdateByRequest::getSourceId);
    }

    @Override
    public void validateRequest(UpdateByRequest request) throws StatusRuntimeException {
        try {
            if (request.getOperationsCount() == 0) {
                throw new IllegalArgumentException("Operations must not be empty");
            }
            if (request.hasOptions()) {
                UpdateByGrpcImpl.adaptOptions(request.getOptions());
            }
            for (UpdateByRequest.UpdateByOperation updateByOperation : request.getOperationsList()) {
                UpdateByGrpcImpl.adaptOperation(updateByOperation);
            }
            for (String columnName : request.getGroupByColumnsList()) {
                ColumnName.of((String)columnName);
            }
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)e.getMessage());
        }
    }

    @Override
    public Table create(UpdateByRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        UpdateByControl control = request.hasOptions() ? UpdateByGrpcImpl.adaptOptions(request.getOptions()) : null;
        List operations = request.getOperationsList().stream().map(UpdateByGrpcImpl::adaptOperation).collect(Collectors.toList());
        List groupByColumns = request.getGroupByColumnsList().stream().map(ColumnName::of).collect(Collectors.toList());
        if (parent.isRefreshing()) {
            return (Table)parent.getUpdateGraph().sharedLock().computeLocked(() -> control == null ? (Table)parent.updateBy((Collection)operations, (Collection)groupByColumns) : (Table)parent.updateBy(control, (Collection)operations, (Collection)groupByColumns));
        }
        return control == null ? (Table)parent.updateBy(operations, groupByColumns) : (Table)parent.updateBy(control, operations, groupByColumns);
    }

    private static UpdateByControl adaptOptions(UpdateByRequest.UpdateByOptions options) {
        UpdateByControl.Builder builder = UpdateByControl.builder();
        if (options.hasUseRedirection()) {
            builder.useRedirection(Boolean.valueOf(options.getUseRedirection()));
        }
        if (options.hasChunkCapacity()) {
            builder.chunkCapacity(options.getChunkCapacity());
        }
        if (options.hasMaxStaticSparseMemoryOverhead()) {
            builder.maxStaticSparseMemoryOverhead(options.getMaxStaticSparseMemoryOverhead());
        }
        if (options.hasInitialHashTableSize()) {
            builder.initialHashTableSize(options.getInitialHashTableSize());
        }
        if (options.hasMaximumLoadFactor()) {
            builder.maximumLoadFactor(options.getMaximumLoadFactor());
        }
        if (options.hasTargetLoadFactor()) {
            builder.targetLoadFactor(options.getTargetLoadFactor());
        }
        if (options.hasMathContext()) {
            builder.mathContext(UpdateByGrpcImpl.adaptMathContext(options.getMathContext()));
        }
        return builder.build();
    }

    private static UpdateByOperation adaptOperation(UpdateByRequest.UpdateByOperation operation) {
        switch (operation.getTypeCase()) {
            case COLUMN: {
                return UpdateByGrpcImpl.adaptColumn(operation.getColumn());
            }
        }
        throw new IllegalArgumentException("Unexpected operation type case: " + String.valueOf(operation.getTypeCase()));
    }

    private static ColumnUpdateOperation adaptColumn(UpdateByRequest.UpdateByOperation.UpdateByColumn column) {
        ColumnUpdateOperation.Builder builder = ColumnUpdateOperation.builder().spec(UpdateByGrpcImpl.adaptSpec(column.getSpec()));
        for (String matchPair : column.getMatchPairsList()) {
            builder.addColumns(Pair.parse((String)matchPair));
        }
        return builder.build();
    }

    private static UpdateBySpec adaptSpec(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec spec) {
        switch (spec.getTypeCase()) {
            case SUM: {
                return UpdateByGrpcImpl.adaptSum(spec.getSum());
            }
            case MIN: {
                return UpdateByGrpcImpl.adaptMin(spec.getMin());
            }
            case MAX: {
                return UpdateByGrpcImpl.adaptMax(spec.getMax());
            }
            case PRODUCT: {
                return UpdateByGrpcImpl.adaptProduct(spec.getProduct());
            }
            case COUNT_WHERE: {
                return UpdateByGrpcImpl.adaptCountWhere(spec.getCountWhere());
            }
            case FILL: {
                return UpdateByGrpcImpl.adaptFill(spec.getFill());
            }
            case EMA: {
                return UpdateByGrpcImpl.adaptEma(spec.getEma());
            }
            case EMS: {
                return UpdateByGrpcImpl.adaptEms(spec.getEms());
            }
            case EM_MAX: {
                return UpdateByGrpcImpl.adaptEmMax(spec.getEmMax());
            }
            case EM_MIN: {
                return UpdateByGrpcImpl.adaptEmMin(spec.getEmMin());
            }
            case EM_STD: {
                return UpdateByGrpcImpl.adaptEmStd(spec.getEmStd());
            }
            case DELTA: {
                return UpdateByGrpcImpl.adaptDelta(spec.getDelta());
            }
            case ROLLING_SUM: {
                return UpdateByGrpcImpl.adaptRollingSum(spec.getRollingSum());
            }
            case ROLLING_GROUP: {
                return UpdateByGrpcImpl.adaptRollingGroup(spec.getRollingGroup());
            }
            case ROLLING_AVG: {
                return UpdateByGrpcImpl.adaptRollingAvg(spec.getRollingAvg());
            }
            case ROLLING_MIN: {
                return UpdateByGrpcImpl.adaptRollingMin(spec.getRollingMin());
            }
            case ROLLING_MAX: {
                return UpdateByGrpcImpl.adaptRollingMax(spec.getRollingMax());
            }
            case ROLLING_PRODUCT: {
                return UpdateByGrpcImpl.adaptRollingProduct(spec.getRollingProduct());
            }
            case ROLLING_COUNT: {
                return UpdateByGrpcImpl.adaptRollingCount(spec.getRollingCount());
            }
            case ROLLING_STD: {
                return UpdateByGrpcImpl.adaptRollingStd(spec.getRollingStd());
            }
            case ROLLING_WAVG: {
                return UpdateByGrpcImpl.adaptRollingWAvg(spec.getRollingWavg());
            }
            case ROLLING_FORMULA: {
                return UpdateByGrpcImpl.adaptRollingFormula(spec.getRollingFormula());
            }
            case ROLLING_COUNT_WHERE: {
                return UpdateByGrpcImpl.adaptRollingCountWhere(spec.getRollingCountWhere());
            }
        }
        throw new IllegalArgumentException("Unexpected spec type: " + String.valueOf(spec.getTypeCase()));
    }

    private static CumSumSpec adaptSum(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeSum sum) {
        return CumSumSpec.of();
    }

    private static CumMinMaxSpec adaptMin(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeMin min) {
        return CumMinMaxSpec.of((boolean)false);
    }

    private static CumMinMaxSpec adaptMax(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeMax max) {
        return CumMinMaxSpec.of((boolean)true);
    }

    private static CumProdSpec adaptProduct(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeProduct product) {
        return CumProdSpec.of();
    }

    private static CumCountWhereSpec adaptCountWhere(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeCountWhere countWhere) {
        return CumCountWhereSpec.of((String)countWhere.getResultColumn(), (String[])((String[])countWhere.getFiltersList().toArray(String[]::new)));
    }

    private static FillBySpec adaptFill(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByFill fill) {
        return FillBySpec.of();
    }

    private static EmaSpec adaptEma(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEma ema) {
        return ema.hasOptions() ? EmaSpec.of((OperationControl)UpdateByGrpcImpl.adaptEmOptions(ema.getOptions()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(ema.getWindowScale())) : EmaSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(ema.getWindowScale()));
    }

    private static EmsSpec adaptEms(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEms ems) {
        return ems.hasOptions() ? EmsSpec.of((OperationControl)UpdateByGrpcImpl.adaptEmOptions(ems.getOptions()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(ems.getWindowScale())) : EmsSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(ems.getWindowScale()));
    }

    private static EmMinMaxSpec adaptEmMax(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMax emMax) {
        return emMax.hasOptions() ? EmMinMaxSpec.of((OperationControl)UpdateByGrpcImpl.adaptEmOptions(emMax.getOptions()), (boolean)true, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(emMax.getWindowScale())) : EmMinMaxSpec.of((boolean)true, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(emMax.getWindowScale()));
    }

    private static EmMinMaxSpec adaptEmMin(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMin emMin) {
        return emMin.hasOptions() ? EmMinMaxSpec.of((OperationControl)UpdateByGrpcImpl.adaptEmOptions(emMin.getOptions()), (boolean)false, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(emMin.getWindowScale())) : EmMinMaxSpec.of((boolean)false, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(emMin.getWindowScale()));
    }

    private static EmStdSpec adaptEmStd(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmStd emStd) {
        return emStd.hasOptions() ? EmStdSpec.of((OperationControl)UpdateByGrpcImpl.adaptEmOptions(emStd.getOptions()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(emStd.getWindowScale())) : EmStdSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(emStd.getWindowScale()));
    }

    private static OperationControl adaptEmOptions(UpdateByEmOptions options) {
        OperationControl.Builder builder = OperationControl.builder();
        if (options.getOnNanValue() == io.deephaven.proto.backplane.grpc.BadDataBehavior.BAD_DATA_BEHAVIOR_NOT_SPECIFIED) {
            builder.onNullValue(UpdateByGrpcImpl.adaptBadDataBehavior(options.getOnNullValue()));
        }
        if (options.getOnNanValue() == io.deephaven.proto.backplane.grpc.BadDataBehavior.BAD_DATA_BEHAVIOR_NOT_SPECIFIED) {
            builder.onNanValue(UpdateByGrpcImpl.adaptBadDataBehavior(options.getOnNanValue()));
        }
        if (options.hasBigValueContext()) {
            builder.bigValueContext(UpdateByGrpcImpl.adaptMathContext(options.getBigValueContext()));
        }
        return builder.build();
    }

    private static DeltaSpec adaptDelta(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByDelta delta) {
        return delta.hasOptions() ? DeltaSpec.of((DeltaControl)UpdateByGrpcImpl.adaptDeltaOptions(delta.getOptions())) : DeltaSpec.of();
    }

    private static DeltaControl adaptDeltaOptions(UpdateByDeltaOptions options) {
        switch (options.getNullBehavior()) {
            case VALUE_DOMINATES: {
                return DeltaControl.VALUE_DOMINATES;
            }
            case ZERO_DOMINATES: {
                return DeltaControl.ZERO_DOMINATES;
            }
        }
        return DeltaControl.NULL_DOMINATES;
    }

    private static RollingSumSpec adaptRollingSum(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingSum sum) {
        return RollingSumSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(sum.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(sum.getForwardWindowScale()));
    }

    private static RollingGroupSpec adaptRollingGroup(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingGroup group) {
        return RollingGroupSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(group.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(group.getForwardWindowScale()));
    }

    private static RollingAvgSpec adaptRollingAvg(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingAvg avg) {
        return RollingAvgSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(avg.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(avg.getForwardWindowScale()));
    }

    private static RollingMinMaxSpec adaptRollingMin(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMin min) {
        return RollingMinMaxSpec.of((boolean)false, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(min.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(min.getForwardWindowScale()));
    }

    private static RollingMinMaxSpec adaptRollingMax(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMax max) {
        return RollingMinMaxSpec.of((boolean)true, (WindowScale)UpdateByGrpcImpl.adaptWindowScale(max.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(max.getForwardWindowScale()));
    }

    private static RollingProductSpec adaptRollingProduct(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingProduct product) {
        return RollingProductSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(product.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(product.getForwardWindowScale()));
    }

    private static RollingCountSpec adaptRollingCount(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingCount count) {
        return RollingCountSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(count.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(count.getForwardWindowScale()));
    }

    private static RollingStdSpec adaptRollingStd(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingStd std) {
        return RollingStdSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(std.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(std.getForwardWindowScale()));
    }

    private static RollingWAvgSpec adaptRollingWAvg(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingWAvg wavg) {
        return RollingWAvgSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(wavg.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(wavg.getForwardWindowScale()), (String)wavg.getWeightColumn());
    }

    private static RollingFormulaSpec adaptRollingFormula(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingFormula formula) {
        return RollingFormulaSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(formula.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(formula.getForwardWindowScale()), (String)formula.getFormula(), (String)formula.getParamToken());
    }

    private static RollingCountWhereSpec adaptRollingCountWhere(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingCountWhere countWhere) {
        return RollingCountWhereSpec.of((WindowScale)UpdateByGrpcImpl.adaptWindowScale(countWhere.getReverseWindowScale()), (WindowScale)UpdateByGrpcImpl.adaptWindowScale(countWhere.getForwardWindowScale()), (String)countWhere.getResultColumn(), (String[])((String[])countWhere.getFiltersList().toArray(String[]::new)));
    }

    private static MathContext adaptMathContext(io.deephaven.proto.backplane.grpc.MathContext bigValueContext) {
        return new MathContext(bigValueContext.getPrecision(), UpdateByGrpcImpl.adaptRoundingMode(bigValueContext.getRoundingMode()));
    }

    private static RoundingMode adaptRoundingMode(MathContext.RoundingMode roundingMode) {
        switch (roundingMode) {
            case UP: {
                return RoundingMode.UP;
            }
            case DOWN: {
                return RoundingMode.DOWN;
            }
            case CEILING: {
                return RoundingMode.CEILING;
            }
            case FLOOR: {
                return RoundingMode.FLOOR;
            }
            case HALF_UP: {
                return RoundingMode.HALF_UP;
            }
            case HALF_DOWN: {
                return RoundingMode.HALF_DOWN;
            }
            case HALF_EVEN: {
                return RoundingMode.HALF_EVEN;
            }
            case UNNECESSARY: {
                return RoundingMode.UNNECESSARY;
            }
        }
        throw new IllegalArgumentException("Unexpected rounding mode: " + String.valueOf(roundingMode));
    }

    private static WindowScale adaptWindowScale(UpdateByWindowScale timescale) {
        switch (timescale.getTypeCase()) {
            case TICKS: {
                return WindowScale.ofTicks((double)timescale.getTicks().getTicks());
            }
            case TIME: {
                return timescale.getTime().hasDurationString() ? WindowScale.ofTime((String)timescale.getTime().getColumn(), (long)DateTimeUtils.parseDurationNanos((String)timescale.getTime().getDurationString())) : WindowScale.ofTime((String)timescale.getTime().getColumn(), (long)timescale.getTime().getNanos());
            }
        }
        throw new IllegalArgumentException("Unexpected timescale type: " + String.valueOf(timescale.getTypeCase()));
    }

    private static BadDataBehavior adaptBadDataBehavior(io.deephaven.proto.backplane.grpc.BadDataBehavior b) {
        switch (b) {
            case RESET: {
                return BadDataBehavior.RESET;
            }
            case SKIP: {
                return BadDataBehavior.SKIP;
            }
            case THROW: {
                return BadDataBehavior.THROW;
            }
            case POISON: {
                return BadDataBehavior.POISON;
            }
        }
        throw new IllegalArgumentException("Unexpected BadDataBehavior: " + String.valueOf(b));
    }
}

