/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import io.deephaven.api.filter.Filter;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.select.WhereFilter;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.UnstructuredFilterTableRequest;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class UnstructuredFilterTableGrpcImpl
extends GrpcTableOperation<UnstructuredFilterTableRequest> {
    @NotNull
    private final ColumnExpressionValidator columnExpressionValidator;

    @Inject
    public UnstructuredFilterTableGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionUnstructuredFilter(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getUnstructuredFilter, UnstructuredFilterTableRequest::getResultId, UnstructuredFilterTableRequest::getSourceId);
        this.columnExpressionValidator = columnExpressionValidator;
    }

    @Override
    public Table create(UnstructuredFilterTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        String[] filters = (String[])request.getFiltersList().toArray(String[]::new);
        WhereFilter[] whereFilters = this.columnExpressionValidator.validateSelectFilters(filters, parent);
        return (Table)parent.where(Filter.and((Filter[])whereFilters));
    }
}

