/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import io.deephaven.api.ColumnName;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.UngroupRequest;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UngroupGrpcImpl
extends GrpcTableOperation<UngroupRequest> {
    @Inject
    public UngroupGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionUngroup(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getUngroup, UngroupRequest::getResultId, UngroupRequest::getSourceId);
    }

    @Override
    public Table create(UngroupRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        List columnsToUngroup = request.getColumnsToUngroupList().stream().map(ColumnName::of).collect(Collectors.toList());
        try (SafeCloseable ignored = UngroupGrpcImpl.lock(parent);){
            Table table = (Table)parent.ungroup(request.getNullFill(), columnsToUngroup);
            return table;
        }
    }

    private static SafeCloseable lock(Table base) {
        if (base.isRefreshing()) {
            return base.getUpdateGraph().sharedLock().lockCloseable();
        }
        return null;
    }
}

