/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.clock.Clock;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.TimeTable;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.TimeTableRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.server.util.Scheduler;
import io.deephaven.time.DateTimeUtils;
import io.grpc.StatusRuntimeException;
import java.time.Instant;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TimeTableGrpcImpl
extends GrpcTableOperation<TimeTableRequest> {
    private final Scheduler scheduler;

    @Inject
    public TimeTableGrpcImpl(TableServiceContextualAuthWiring authWiring, Scheduler scheduler) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionTimeTable(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getTimeTable, TimeTableRequest::getResultId);
        this.scheduler = scheduler;
    }

    @Override
    public void validateRequest(TimeTableRequest request) throws StatusRuntimeException {
        long periodNanos = TimeTableGrpcImpl.adaptPeriod(request);
        if (periodNanos <= 0L) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("periodNanos must be >= 0 (found: " + periodNanos + ")"));
        }
    }

    @Override
    public Table create(TimeTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)0);
        return new TimeTable((UpdateSourceRegistrar)ExecutionContext.getContext().getUpdateGraph(), (Clock)this.scheduler, TimeTableGrpcImpl.adaptStartTime(request), TimeTableGrpcImpl.adaptPeriod(request), request.getBlinkTable());
    }

    private static Instant adaptStartTime(TimeTableRequest request) {
        if (request.hasStartTimeString()) {
            return DateTimeUtils.parseInstant((String)request.getStartTimeString());
        }
        return request.getStartTimeNanos() <= 0L ? null : DateTimeUtils.epochNanosToInstant((long)request.getStartTimeNanos());
    }

    private static long adaptPeriod(TimeTableRequest request) {
        if (request.hasPeriodString()) {
            return DateTimeUtils.parseDurationNanos((String)request.getPeriodString());
        }
        return request.getPeriodNanos();
    }
}

