/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.clientsupport.gotorow.SeekRow;
import io.deephaven.csv.util.MutableObject;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.util.EngineMetrics;
import io.deephaven.extensions.barrage.util.ExportUtil;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.AggregateAllRequest;
import io.deephaven.proto.backplane.grpc.AggregateRequest;
import io.deephaven.proto.backplane.grpc.AjRajTablesRequest;
import io.deephaven.proto.backplane.grpc.ApplyPreviewColumnsRequest;
import io.deephaven.proto.backplane.grpc.AsOfJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.ColumnStatisticsRequest;
import io.deephaven.proto.backplane.grpc.ComboAggregateRequest;
import io.deephaven.proto.backplane.grpc.CreateInputTableRequest;
import io.deephaven.proto.backplane.grpc.CrossJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.DropColumnsRequest;
import io.deephaven.proto.backplane.grpc.EmptyTableRequest;
import io.deephaven.proto.backplane.grpc.ExactJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse;
import io.deephaven.proto.backplane.grpc.ExportedTableUpdateMessage;
import io.deephaven.proto.backplane.grpc.ExportedTableUpdatesRequest;
import io.deephaven.proto.backplane.grpc.FetchTableRequest;
import io.deephaven.proto.backplane.grpc.FilterTableRequest;
import io.deephaven.proto.backplane.grpc.FlattenRequest;
import io.deephaven.proto.backplane.grpc.HeadOrTailByRequest;
import io.deephaven.proto.backplane.grpc.HeadOrTailRequest;
import io.deephaven.proto.backplane.grpc.LeftJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.Literal;
import io.deephaven.proto.backplane.grpc.MergeTablesRequest;
import io.deephaven.proto.backplane.grpc.MetaTableRequest;
import io.deephaven.proto.backplane.grpc.MultiJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.NaturalJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.RangeJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.RunChartDownsampleRequest;
import io.deephaven.proto.backplane.grpc.SeekRowRequest;
import io.deephaven.proto.backplane.grpc.SeekRowResponse;
import io.deephaven.proto.backplane.grpc.SelectDistinctRequest;
import io.deephaven.proto.backplane.grpc.SelectOrUpdateRequest;
import io.deephaven.proto.backplane.grpc.SliceRequest;
import io.deephaven.proto.backplane.grpc.SnapshotTableRequest;
import io.deephaven.proto.backplane.grpc.SnapshotWhenTableRequest;
import io.deephaven.proto.backplane.grpc.SortTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.TableServiceGrpc;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.grpc.TimeTableRequest;
import io.deephaven.proto.backplane.grpc.UngroupRequest;
import io.deephaven.proto.backplane.grpc.UnstructuredFilterTableRequest;
import io.deephaven.proto.backplane.grpc.UpdateByRequest;
import io.deephaven.proto.backplane.grpc.WhereInRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.server.table.ExportedTableUpdateListener;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.mutable.MutableInt;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class TableServiceGrpcImpl
extends TableServiceGrpc.TableServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(TableServiceGrpcImpl.class);
    private final TicketRouter ticketRouter;
    private final SessionService sessionService;
    private final TableServiceContextualAuthWiring authWiring;
    private final Map<BatchTableRequest.Operation.OpCase, GrpcTableOperation<?>> operationMap;
    private final ExportedTableUpdateListener.Factory exportedTableUpdateListenerFactory;

    @Inject
    public TableServiceGrpcImpl(TicketRouter ticketRouter, SessionService sessionService, TableServiceContextualAuthWiring authWiring, Map<BatchTableRequest.Operation.OpCase, GrpcTableOperation<?>> operationMap, ExportedTableUpdateListener.Factory exportedTableUpdateListenerFactory) {
        this.ticketRouter = ticketRouter;
        this.sessionService = sessionService;
        this.authWiring = authWiring;
        this.operationMap = operationMap;
        this.exportedTableUpdateListenerFactory = exportedTableUpdateListenerFactory;
    }

    private <T> GrpcTableOperation<T> getOp(BatchTableRequest.Operation.OpCase op) {
        GrpcTableOperation<?> operation = this.operationMap.get(op);
        if (operation == null) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("BatchTableRequest.Operation.OpCode is unset, incompatible, or not yet supported. (found: " + String.valueOf(op) + ")"));
        }
        return operation;
    }

    public void emptyTable(@NotNull EmptyTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.EMPTY_TABLE, request, responseObserver);
    }

    public void timeTable(@NotNull TimeTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.TIME_TABLE, request, responseObserver);
    }

    public void mergeTables(@NotNull MergeTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.MERGE, request, responseObserver);
    }

    public void selectDistinct(@NotNull SelectDistinctRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SELECT_DISTINCT, request, responseObserver);
    }

    public void update(@NotNull SelectOrUpdateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.UPDATE, request, responseObserver);
    }

    public void lazyUpdate(@NotNull SelectOrUpdateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.LAZY_UPDATE, request, responseObserver);
    }

    public void view(@NotNull SelectOrUpdateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.VIEW, request, responseObserver);
    }

    public void updateView(@NotNull SelectOrUpdateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.UPDATE_VIEW, request, responseObserver);
    }

    public void select(@NotNull SelectOrUpdateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SELECT, request, responseObserver);
    }

    public void headBy(@NotNull HeadOrTailByRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.HEAD_BY, request, responseObserver);
    }

    public void tailBy(@NotNull HeadOrTailByRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.TAIL_BY, request, responseObserver);
    }

    public void head(@NotNull HeadOrTailRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.HEAD, request, responseObserver);
    }

    public void tail(@NotNull HeadOrTailRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.TAIL, request, responseObserver);
    }

    public void ungroup(@NotNull UngroupRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.UNGROUP, request, responseObserver);
    }

    public void comboAggregate(@NotNull ComboAggregateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.COMBO_AGGREGATE, request, responseObserver);
    }

    public void aggregateAll(@NotNull AggregateAllRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.AGGREGATE_ALL, request, responseObserver);
    }

    public void aggregate(@NotNull AggregateRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.AGGREGATE, request, responseObserver);
    }

    public void snapshot(@NotNull SnapshotTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SNAPSHOT, request, responseObserver);
    }

    public void snapshotWhen(@NotNull SnapshotWhenTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SNAPSHOT_WHEN, request, responseObserver);
    }

    public void dropColumns(@NotNull DropColumnsRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.DROP_COLUMNS, request, responseObserver);
    }

    public void filter(@NotNull FilterTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.FILTER, request, responseObserver);
    }

    public void unstructuredFilter(@NotNull UnstructuredFilterTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.UNSTRUCTURED_FILTER, request, responseObserver);
    }

    public void sort(@NotNull SortTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SORT, request, responseObserver);
    }

    public void flatten(@NotNull FlattenRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.FLATTEN, request, responseObserver);
    }

    public void metaTable(@NotNull MetaTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.META_TABLE, request, responseObserver);
    }

    public void crossJoinTables(@NotNull CrossJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.CROSS_JOIN, request, responseObserver);
    }

    public void naturalJoinTables(@NotNull NaturalJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.NATURAL_JOIN, request, responseObserver);
    }

    public void exactJoinTables(@NotNull ExactJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.EXACT_JOIN, request, responseObserver);
    }

    public void leftJoinTables(@NotNull LeftJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.LEFT_JOIN, request, responseObserver);
    }

    public void asOfJoinTables(@NotNull AsOfJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.AS_OF_JOIN, request, responseObserver);
    }

    public void ajTables(@NotNull AjRajTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.AJ, request, responseObserver);
    }

    public void rajTables(@NotNull AjRajTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.RAJ, request, responseObserver);
    }

    public void multiJoinTables(MultiJoinTablesRequest request, StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.MULTI_JOIN, request, responseObserver);
    }

    public void rangeJoinTables(@NotNull RangeJoinTablesRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.RANGE_JOIN, request, responseObserver);
    }

    public void runChartDownsample(@NotNull RunChartDownsampleRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.RUN_CHART_DOWNSAMPLE, request, responseObserver);
    }

    public void fetchTable(@NotNull FetchTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.FETCH_TABLE, request, responseObserver);
    }

    public void applyPreviewColumns(@NotNull ApplyPreviewColumnsRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.APPLY_PREVIEW_COLUMNS, request, responseObserver);
    }

    public void createInputTable(@NotNull CreateInputTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.CREATE_INPUT_TABLE, request, responseObserver);
    }

    public void updateBy(@NotNull UpdateByRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.UPDATE_BY, request, responseObserver);
    }

    public void slice(@NotNull SliceRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.SLICE, request, responseObserver);
    }

    private Object getSeekValue(@NotNull Literal literal, @NotNull Class<?> dataType) {
        if (literal.hasStringValue()) {
            if (BigDecimal.class.isAssignableFrom(dataType)) {
                return new BigDecimal(literal.getStringValue());
            }
            if (BigInteger.class.isAssignableFrom(dataType)) {
                return new BigInteger(literal.getStringValue());
            }
            if (!String.class.isAssignableFrom(dataType) && dataType != Character.TYPE) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Invalid String type for seek: " + String.valueOf(dataType)));
            }
            return literal.getStringValue();
        }
        if (literal.hasNanoTimeValue()) {
            if (!Instant.class.isAssignableFrom(dataType)) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Invalid date type for seek: " + String.valueOf(dataType)));
            }
            return DateTimeUtils.epochNanosToInstant((long)literal.getNanoTimeValue());
        }
        if (literal.hasLongValue()) {
            Long longValue = literal.getLongValue();
            if (dataType == Byte.TYPE) {
                return longValue.byteValue();
            }
            if (dataType == Short.TYPE) {
                return longValue.shortValue();
            }
            if (dataType == Integer.TYPE) {
                return longValue.intValue();
            }
            if (dataType == Long.TYPE) {
                return longValue;
            }
            if (dataType == Float.TYPE) {
                return Float.valueOf(longValue.floatValue());
            }
            if (dataType == Double.TYPE) {
                return longValue.doubleValue();
            }
        } else if (literal.hasDoubleValue()) {
            Double doubleValue = literal.getDoubleValue();
            if (dataType == Byte.TYPE) {
                return doubleValue.byteValue();
            }
            if (dataType == Short.TYPE) {
                return doubleValue.shortValue();
            }
            if (dataType == Integer.TYPE) {
                return doubleValue.intValue();
            }
            if (dataType == Long.TYPE) {
                return doubleValue.longValue();
            }
            if (dataType == Float.TYPE) {
                return Float.valueOf(doubleValue.floatValue());
            }
            if (dataType == Double.TYPE) {
                return doubleValue;
            }
        } else if (literal.hasBoolValue()) {
            return literal.getBoolValue();
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Invalid column type for seek: " + String.valueOf(dataType)));
    }

    public void whereIn(@NotNull WhereInRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.WHERE_IN, request, responseObserver);
    }

    public void seekRow(@NotNull SeekRowRequest request, @NotNull StreamObserver<SeekRowResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        Ticket sourceId = request.getSourceId();
        if (sourceId.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"No consoleId supplied");
        }
        String description = "TableService#seekRow(table=" + this.ticketRouter.getLogNameFor(sourceId, "sourceId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject exportedTable = this.ticketRouter.resolve(session, sourceId, "sourceId");
            session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).require(exportedTable).onError(responseObserver).onSuccess(response -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)response)).submit(() -> {
                Table table = (Table)exportedTable.get();
                this.authWiring.checkPermissionSeekRow(session.getAuthContext(), request, Collections.singletonList(table));
                String columnName = request.getColumnName();
                Class dataType = table.getDefinition().getColumn(columnName).getDataType();
                Object seekValue = this.getSeekValue(request.getSeekValue(), dataType);
                long result = new SeekRow(request.getStartingRow(), columnName, seekValue, request.getInsensitive(), request.getContains(), request.getIsBackward()).seek(table);
                return SeekRowResponse.newBuilder().setResultRow(result).build();
            });
        }
    }

    public void computeColumnStatistics(@NotNull ColumnStatisticsRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        this.oneShotOperationWrapper(BatchTableRequest.Operation.OpCase.COLUMN_STATISTICS, request, responseObserver);
    }

    public void batch(@NotNull BatchTableRequest request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)request, 1);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        for (BatchTableRequest.Operation operation : request.getOpsList()) {
            GrpcErrorHelper.checkHasOneOf((Message)operation, "op");
            GrpcErrorHelper.checkHasNoUnknownFields((Message)operation);
        }
        SessionState session = this.sessionService.getCurrentSession();
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)"TableService#batch()", (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored1 = queryPerformanceRecorder.startQuery();){
            MutableInt offset = new MutableInt(0);
            List<BatchExportBuilder> exportBuilders = request.getOpsList().stream().map(op -> this.createBatchExportBuilder(offset.getAndIncrement(), session, queryPerformanceRecorder, (BatchTableRequest.Operation)op)).collect(Collectors.toList());
            exportBuilders.forEach(export -> export.resolveDependencies(session, exportBuilders));
            AtomicInteger remaining = new AtomicInteger(1 + exportBuilders.size());
            AtomicReference firstFailure = new AtomicReference();
            Runnable onOneResolved = () -> {
                int numRemaining = remaining.decrementAndGet();
                Assert.geqZero((int)numRemaining, (String)"numRemaining");
                if (numRemaining > 0) {
                    return;
                }
                StatusRuntimeException failure = (StatusRuntimeException)firstFailure.get();
                try (SafeCloseable ignored2 = queryPerformanceRecorder.resumeQuery();){
                    if (queryPerformanceRecorder.endQuery()) {
                        EngineMetrics.getInstance().logQueryProcessingResults(queryPerformanceRecorder, (Exception)failure);
                    }
                }
                if (failure != null) {
                    GrpcUtil.safelyError((StreamObserver)responseObserver, (StatusRuntimeException)failure);
                } else {
                    GrpcUtil.safelyComplete((StreamObserver)responseObserver);
                }
            };
            for (int i = 0; i < exportBuilders.size(); ++i) {
                BatchExportBuilder exportBuilder = (BatchExportBuilder)exportBuilders.get(i);
                int exportId = exportBuilder.exportBuilder.getExportId();
                TableReference resultId = exportId == 0 ? TableReference.newBuilder().setBatchOffset(i).build() : ExportTicketHelper.tableReference((int)exportId);
                MutableObject successResponse = new MutableObject();
                exportBuilder.exportBuilder.onError((result, errorContext, cause, dependentId) -> {
                    Object errorInfo = errorContext;
                    if (dependentId != null) {
                        errorInfo = (String)errorInfo + " dependency: " + dependentId;
                    }
                    if (cause instanceof StatusRuntimeException) {
                        errorInfo = (String)errorInfo + " cause: " + cause.getMessage();
                        firstFailure.compareAndSet(null, (StatusRuntimeException)cause);
                    }
                    ExportedTableCreationResponse response = ExportedTableCreationResponse.newBuilder().setResultId(resultId).setSuccess(false).setErrorInfo((String)errorInfo).build();
                    GrpcUtil.safelyOnNext((StreamObserver)responseObserver, (Object)response);
                    onOneResolved.run();
                }).onSuccess(table -> {
                    GrpcUtil.safelyOnNext((StreamObserver)responseObserver, (Object)((ExportedTableCreationResponse)successResponse.getValue()));
                    onOneResolved.run();
                }).submit(() -> {
                    Table result = exportBuilder.doExport();
                    successResponse.setValue((Object)ExportUtil.buildTableCreationResponse((TableReference)resultId, (Table)result));
                    return result;
                });
            }
            queryPerformanceRecorder.suspendQuery();
            onOneResolved.run();
        }
    }

    public void exportedTableUpdates(@NotNull ExportedTableUpdatesRequest request, @NotNull StreamObserver<ExportedTableUpdateMessage> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        this.authWiring.checkPermissionExportedTableUpdates(session.getAuthContext(), request, Collections.emptyList());
        ExportedTableUpdateListener listener = this.exportedTableUpdateListenerFactory.create(session, responseObserver);
        session.addExportListener(listener);
        ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> session.removeExportListener(listener));
    }

    public void getExportedTableCreationResponse(@NotNull Ticket request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        if (request.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"No request ticket supplied");
        }
        String description = "TableService#getExportedTableCreationResponse(table=" + this.ticketRouter.getLogNameFor(request, "request") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject export = this.ticketRouter.resolve(session, request, "request");
            session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).require(export).onError(responseObserver).onSuccess(response -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)response)).submit(() -> {
                Object obj = export.get();
                if (!(obj instanceof Table)) {
                    throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"Ticket is not a table");
                }
                this.authWiring.checkPermissionGetExportedTableCreationResponse(session.getAuthContext(), request, Collections.singletonList((Table)obj));
                return ExportUtil.buildTableCreationResponse((Ticket)request, (Table)((Table)obj));
            });
        }
    }

    private <T> void oneShotOperationWrapper(BatchTableRequest.Operation.OpCase op, @NotNull T request, @NotNull StreamObserver<ExportedTableCreationResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        GrpcTableOperation operation = this.getOp(op);
        Ticket resultId = operation.getResultTicket(request);
        if (resultId.getTicket().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"No result ticket supplied");
        }
        String description = "TableService#" + op.name() + "(resultId=" + this.ticketRouter.getLogNameFor(resultId, "TableService") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            operation.validateRequest(request);
            List dependencies = operation.getTableReferences(request).stream().map(ref -> this.resolveOneShotReference(session, (TableReference)ref)).collect(Collectors.toList());
            MutableObject response = new MutableObject();
            session.newExport(resultId, "resultId").require(dependencies).queryPerformanceRecorder(queryPerformanceRecorder).onError(responseObserver).onSuccess(result -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)((ExportedTableCreationResponse)response.getValue()))).submit(() -> {
                operation.checkPermission(request, dependencies);
                Table result = operation.create(request, dependencies);
                response.setValue((Object)ExportUtil.buildTableCreationResponse((Ticket)resultId, (Table)result));
                return result;
            });
        }
    }

    private SessionState.ExportObject<Table> resolveOneShotReference(@NotNull SessionState session, @NotNull TableReference ref) {
        if (!ref.hasTicket()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)"One-shot operations must use ticket references");
        }
        return this.ticketRouter.resolve(session, ref.getTicket(), "sourceId");
    }

    private SessionState.ExportObject<Table> resolveBatchReference(@NotNull SessionState session, @NotNull List<BatchExportBuilder<?>> exportBuilders, @NotNull TableReference ref) {
        switch (ref.getRefCase()) {
            case TICKET: {
                return this.ticketRouter.resolve(session, ref.getTicket(), "sourceId");
            }
            case BATCH_OFFSET: {
                int offset = ref.getBatchOffset();
                if (offset < 0 || offset >= exportBuilders.size()) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("invalid table reference: " + String.valueOf(ref)));
                }
                return exportBuilders.get((int)offset).exportBuilder.getExport();
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("invalid table reference: " + String.valueOf(ref)));
    }

    private <T> BatchExportBuilder<T> createBatchExportBuilder(int offset, @NotNull SessionState session, @NotNull QueryPerformanceRecorder batchQueryPerformanceRecorder, BatchTableRequest.Operation op) {
        GrpcTableOperation<T> operation = this.getOp(op.getOpCase());
        T request = operation.getRequestFromOperation(op);
        operation.validateRequest(request);
        Ticket resultId = operation.getResultTicket(request);
        boolean hasResultId = !resultId.getTicket().isEmpty();
        SessionState.ExportBuilder<Table> exportBuilder = hasResultId ? session.newExport(resultId, "resultId") : session.nonExport();
        String resultDescription = hasResultId ? "resultId=" + this.ticketRouter.getLogNameFor(resultId, "resultId") + ", " : "";
        String description = "TableService#" + op.getOpCase().name() + "(" + resultDescription + "batchOffset=" + offset + ")";
        exportBuilder.queryPerformanceRecorder(QueryPerformanceRecorder.newSubQuery((String)description, (QueryPerformanceRecorder)batchQueryPerformanceRecorder, (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY));
        return new BatchExportBuilder<T>(operation, request, exportBuilder);
    }

    private class BatchExportBuilder<T> {
        private final GrpcTableOperation<T> operation;
        private final T request;
        private final SessionState.ExportBuilder<Table> exportBuilder;
        List<SessionState.ExportObject<Table>> dependencies;

        BatchExportBuilder(@NotNull GrpcTableOperation<T> operation, @NotNull T request, SessionState.ExportBuilder<Table> exportBuilder) {
            this.operation = Objects.requireNonNull(operation);
            this.request = Objects.requireNonNull(request);
            this.exportBuilder = Objects.requireNonNull(exportBuilder);
        }

        void resolveDependencies(@NotNull SessionState session, @NotNull List<BatchExportBuilder<?>> exportBuilders) {
            this.dependencies = this.operation.getTableReferences(this.request).stream().map(ref -> TableServiceGrpcImpl.this.resolveBatchReference(session, exportBuilders, (TableReference)ref)).collect(Collectors.toList());
            this.exportBuilder.require(this.dependencies);
        }

        Table doExport() {
            this.operation.checkPermission(this.request, this.dependencies);
            return this.operation.create(this.request, this.dependencies);
        }
    }
}

