/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.AbsoluteSortColumnConventions;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SortDescriptor;
import io.deephaven.proto.backplane.grpc.SortTableRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SortTableGrpcImpl
extends GrpcTableOperation<SortTableRequest> {
    @Inject
    public SortTableGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionSort(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSort, SortTableRequest::getResultId, SortTableRequest::getSourceId);
    }

    @Override
    public Table create(SortTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Table original;
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table result = original = sourceTables.get(0).get();
        ArrayList<String> absColumns = new ArrayList<String>();
        ArrayList<Selectable> absViews = new ArrayList<Selectable>();
        for (int si = request.getSortsCount() - 1; si >= 0; --si) {
            if (!request.getSorts(si).getIsAbsolute()) continue;
            String columnName = request.getSorts(si).getColumnName();
            String absName = AbsoluteSortColumnConventions.baseColumnNameToAbsoluteName((String)columnName);
            absColumns.add(absName);
            absViews.add(AbsoluteSortColumnConventions.makeSelectable((String)absName, (String)columnName));
        }
        if (!absViews.isEmpty()) {
            result = (Table)result.updateView(absViews);
        }
        ArrayList<SortColumn> sortColumns = new ArrayList<SortColumn>();
        boolean shouldReverse = false;
        block6: for (int si = 0; si < request.getSortsCount(); ++si) {
            String columnName;
            SortDescriptor sort = request.getSorts(si);
            int direction = 0;
            switch (sort.getDirection()) {
                case REVERSE: {
                    shouldReverse = !shouldReverse;
                    continue block6;
                }
                case DESCENDING: {
                    direction = -1;
                    break;
                }
                case ASCENDING: {
                    direction = 1;
                    break;
                }
                default: {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Unexpected sort direction: " + direction));
                }
            }
            String string = columnName = sort.getIsAbsolute() ? AbsoluteSortColumnConventions.baseColumnNameToAbsoluteName((String)sort.getColumnName()) : sort.getColumnName();
            if (shouldReverse) {
                direction *= -1;
            }
            if (direction == -1) {
                sortColumns.add(SortColumn.desc((ColumnName)ColumnName.of((String)columnName)));
                continue;
            }
            sortColumns.add(SortColumn.asc((ColumnName)ColumnName.of((String)columnName)));
        }
        if (sortColumns.size() > 0) {
            result = (Table)result.sort(sortColumns);
        }
        if (shouldReverse) {
            result = (Table)result.reverse();
        }
        if (!absColumns.isEmpty()) {
            Object uniqueKeys;
            result = (Table)result.dropColumns(absColumns);
            Object keyColumns = original.getAttribute("keyColumns");
            if (keyColumns != null) {
                ((QueryTable)result).setAttribute("keyColumns", keyColumns);
            }
            if ((uniqueKeys = original.getAttribute("uniqueKeys")) != null) {
                ((QueryTable)result).setAttribute("uniqueKeys", uniqueKeys);
            }
        }
        return result;
    }
}

