/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.snapshot.SnapshotWhenOptions;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SnapshotWhenTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SnapshotWhenTableGrpcImpl
extends GrpcTableOperation<SnapshotWhenTableRequest> {
    private static List<TableReference> refs(SnapshotWhenTableRequest request) {
        return Arrays.asList(request.getBaseId(), request.getTriggerId());
    }

    private static SnapshotWhenOptions options(SnapshotWhenTableRequest request) {
        SnapshotWhenOptions.Builder builder = SnapshotWhenOptions.builder();
        if (request.getInitial()) {
            builder.addFlags(SnapshotWhenOptions.Flag.INITIAL);
        }
        if (request.getIncremental()) {
            builder.addFlags(SnapshotWhenOptions.Flag.INCREMENTAL);
        }
        if (request.getHistory()) {
            builder.addFlags(SnapshotWhenOptions.Flag.HISTORY);
        }
        for (String stampColumn : request.getStampColumnsList()) {
            builder.addStampColumns(JoinAddition.parse((String)stampColumn));
        }
        return builder.build();
    }

    @Inject
    public SnapshotWhenTableGrpcImpl(TableServiceContextualAuthWiring auth) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)auth).checkPermissionSnapshotWhen(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSnapshotWhen, SnapshotWhenTableRequest::getResultId, SnapshotWhenTableGrpcImpl::refs);
    }

    @Override
    public void validateRequest(SnapshotWhenTableRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getBaseId());
        Common.validate(request.getTriggerId());
        try {
            SnapshotWhenTableGrpcImpl.options(request);
        }
        catch (UnsupportedOperationException e) {
            throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)e.getMessage());
        }
    }

    @Override
    public Table create(SnapshotWhenTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)2);
        Table base = sourceTables.get(0).get();
        Table trigger = sourceTables.get(1).get();
        SnapshotWhenOptions options = SnapshotWhenTableGrpcImpl.options(request);
        try (SafeCloseable ignored = this.lock(base, trigger);){
            Table table = (Table)base.snapshotWhen((Object)trigger, options);
            return table;
        }
    }

    private SafeCloseable lock(Table base, Table trigger) {
        if (base.isRefreshing()) {
            UpdateGraph updateGraph = base.getUpdateGraph();
            return updateGraph.sharedLock().lockCloseable();
        }
        if (trigger.isRefreshing()) {
            UpdateGraph updateGraph = trigger.getUpdateGraph();
            return updateGraph.sharedLock().lockCloseable();
        }
        return null;
    }
}

