/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SnapshotTableRequest;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SnapshotTableGrpcImpl
extends GrpcTableOperation<SnapshotTableRequest> {
    @Inject
    public SnapshotTableGrpcImpl(TableServiceContextualAuthWiring auth) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)auth).checkPermissionSnapshot(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSnapshot, SnapshotTableRequest::getResultId, SnapshotTableRequest::getSourceId);
    }

    @Override
    public void validateRequest(SnapshotTableRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getSourceId());
    }

    @Override
    public Table create(SnapshotTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table base = sourceTables.get(0).get();
        try (SafeCloseable ignored = this.lock(base);){
            Table table = (Table)base.snapshot();
            return table;
        }
    }

    private SafeCloseable lock(Table base) {
        if (base.isRefreshing()) {
            return base.getUpdateGraph().sharedLock().lockCloseable();
        }
        return null;
    }
}

