/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SliceRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SliceGrpcImpl
extends GrpcTableOperation<SliceRequest> {
    @Inject
    public SliceGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionSlice(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSlice, SliceRequest::getResultId, SliceRequest::getSourceId);
    }

    @Override
    public void validateRequest(SliceRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getSourceId());
        if (request.getFirstPositionInclusive() >= 0L && request.getLastPositionExclusive() >= 0L && request.getLastPositionExclusive() < request.getFirstPositionInclusive()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Cannot slice with a non-negative start position that is after a non-negative end position.");
        }
        if (request.getFirstPositionInclusive() < 0L && request.getLastPositionExclusive() < 0L && request.getLastPositionExclusive() < request.getFirstPositionInclusive()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Cannot slice with a negative start position that is after a negative end position.");
        }
    }

    @Override
    public final Table create(SliceRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table sourceTable = sourceTables.get(0).get();
        return (Table)sourceTable.slice(request.getFirstPositionInclusive(), request.getLastPositionExclusive());
    }
}

