/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.SelectDistinctRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SelectDistinctGrpcImpl
extends GrpcTableOperation<SelectDistinctRequest> {
    @Inject
    public SelectDistinctGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionSelectDistinct(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getSelectDistinct, SelectDistinctRequest::getResultId, SelectDistinctRequest::getSourceId);
    }

    @Override
    public Table create(SelectDistinctRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        List requestedMissing = request.getColumnNamesList().stream().filter(Predicate.not(parent.getDefinition().getColumnNameSet()::contains)).collect(Collectors.toList());
        if (!requestedMissing.isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("column(s) not found: " + String.join((CharSequence)", ", requestedMissing)));
        }
        return (Table)parent.selectDistinct((String[])request.getColumnNamesList().toArray(String[]::new));
    }
}

