/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RangeEndRule;
import io.deephaven.api.RangeJoinMatch;
import io.deephaven.api.RangeStartRule;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.proto.backplane.grpc.Aggregation;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.RangeJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.AggregationAdapter;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public final class RangeJoinGrpcImpl
extends GrpcTableOperation<RangeJoinTablesRequest> {
    @Inject
    public RangeJoinGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionRangeJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getRangeJoin, RangeJoinTablesRequest::getResultId, RangeJoinGrpcImpl::refs);
    }

    private static List<TableReference> refs(RangeJoinTablesRequest request) {
        return List.of(request.getLeftId(), request.getRightId());
    }

    @Override
    public void validateRequest(RangeJoinTablesRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        if (!RangeJoinGrpcImpl.hasRangeMatchString(request)) {
            GrpcErrorHelper.checkHasField((Message)request, 5);
            GrpcErrorHelper.checkHasField((Message)request, 6);
            GrpcErrorHelper.checkHasField((Message)request, 7);
            GrpcErrorHelper.checkHasField((Message)request, 8);
            GrpcErrorHelper.checkHasField((Message)request, 9);
        } else {
            try {
                GrpcErrorHelper.checkDoesNotHaveField((Message)request, 5);
                GrpcErrorHelper.checkDoesNotHaveField((Message)request, 6);
                GrpcErrorHelper.checkDoesNotHaveField((Message)request, 7);
                GrpcErrorHelper.checkDoesNotHaveField((Message)request, 8);
                GrpcErrorHelper.checkDoesNotHaveField((Message)request, 9);
            }
            catch (Exception ex) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("If `range_match` is provided, range details should remain empty. \nInternal error: " + ex.getMessage()));
            }
        }
        GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)request, 10);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getLeftId());
        Common.validate(request.getRightId());
        try {
            for (String exactMatch : request.getExactMatchColumnsList()) {
                JoinMatch.parse((String)exactMatch);
            }
            if (!RangeJoinGrpcImpl.hasRangeMatchString(request)) {
                RangeJoinGrpcImpl.adaptRangeMatch(request);
            } else {
                RangeJoinMatch.parse((String)request.getRangeMatch());
            }
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)e.getMessage());
        }
        for (Aggregation aggregation : request.getAggregationsList()) {
            AggregationAdapter.validate(aggregation);
        }
    }

    @Override
    public Table create(RangeJoinTablesRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)2);
        Assert.gtZero((int)request.getAggregationsCount(), (String)"request.getAggregationsCount()");
        Table leftTable = sourceTables.get(0).get();
        Table rightTable = sourceTables.get(1).get();
        List exactMatches = JoinMatch.from((Collection)request.getExactMatchColumnsList());
        RangeJoinMatch rangeMatch = !RangeJoinGrpcImpl.hasRangeMatchString(request) ? RangeJoinGrpcImpl.adaptRangeMatch(request) : RangeJoinMatch.parse((String)request.getRangeMatch());
        Collection aggregations = request.getAggregationsList().stream().map(AggregationAdapter::adapt).collect(Collectors.toList());
        if (!leftTable.isRefreshing() && !rightTable.isRefreshing()) {
            return (Table)leftTable.rangeJoin((Object)rightTable, (Collection)exactMatches, rangeMatch, aggregations);
        }
        return (Table)leftTable.getUpdateGraph(new NotificationQueue.Dependency[]{rightTable}).sharedLock().computeLocked(() -> (Table)leftTable.rangeJoin((Object)rightTable, exactMatches, rangeMatch, aggregations));
    }

    private static boolean hasRangeMatchString(@NotNull RangeJoinTablesRequest message) {
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByNumber(11);
        return message.hasField(fieldDescriptor);
    }

    private static RangeJoinMatch adaptRangeMatch(@NotNull RangeJoinTablesRequest request) {
        return RangeJoinMatch.of((ColumnName)ColumnName.parse((String)request.getLeftStartColumn()), (RangeStartRule)RangeJoinGrpcImpl.adapt(request.getRangeStartRule()), (ColumnName)ColumnName.parse((String)request.getRightRangeColumn()), (RangeEndRule)RangeJoinGrpcImpl.adapt(request.getRangeEndRule()), (ColumnName)ColumnName.parse((String)request.getLeftEndColumn()));
    }

    private static RangeStartRule adapt(RangeJoinTablesRequest.RangeStartRule rule) {
        switch (rule) {
            case LESS_THAN: {
                return RangeStartRule.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return RangeStartRule.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL_ALLOW_PRECEDING: {
                return RangeStartRule.LESS_THAN_OR_EQUAL_ALLOW_PRECEDING;
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)String.format("Unrecognized range start rule %s for range join", rule));
    }

    private static RangeEndRule adapt(RangeJoinTablesRequest.RangeEndRule rule) {
        switch (rule) {
            case GREATER_THAN: {
                return RangeEndRule.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return RangeEndRule.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING: {
                return RangeEndRule.GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING;
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)String.format("Unrecognized range end rule %s for range join", rule));
    }
}

