/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.engine.table.MultiJoinFactory;
import io.deephaven.engine.table.MultiJoinInput;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.MultiJoinTablesRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MultiJoinGrpcImpl
extends GrpcTableOperation<MultiJoinTablesRequest> {
    @Inject
    public MultiJoinGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionMultiJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getMultiJoin, MultiJoinTablesRequest::getResultId, (T request) -> request.getMultiJoinInputsList().stream().map(io.deephaven.proto.backplane.grpc.MultiJoinInput::getSourceId).collect(Collectors.toList()));
    }

    @Override
    public void validateRequest(MultiJoinTablesRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        if (request.getMultiJoinInputsList().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Cannot join zero source tables.");
        }
        request.getMultiJoinInputsList().forEach(input -> {
            GrpcErrorHelper.checkHasNoUnknownFields((Message)input);
            GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)input, 2);
            Common.validate(input.getSourceId());
        });
    }

    @Override
    public Table create(MultiJoinTablesRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Table firstTable = sourceTables.get(0).get();
        Table[] allTables = (Table[])sourceTables.stream().map(SessionState.ExportObject::get).toArray(Table[]::new);
        MultiJoinInput[] multiJoinInputs = new MultiJoinInput[request.getMultiJoinInputsCount()];
        for (int i = 0; i < request.getMultiJoinInputsCount(); ++i) {
            Table table = sourceTables.get(i).get();
            io.deephaven.proto.backplane.grpc.MultiJoinInput mjInput = request.getMultiJoinInputs(i);
            String[] columnsToMatch = (String[])mjInput.getColumnsToMatchList().toArray((Object[])new String[0]);
            String[] columnsToAdd = (String[])mjInput.getColumnsToAddList().toArray((Object[])new String[0]);
            multiJoinInputs[i] = MultiJoinInput.of((Table)table, (String[])columnsToMatch, (String[])columnsToAdd);
        }
        return (Table)firstTable.getUpdateGraph((NotificationQueue.Dependency[])allTables).sharedLock().computeLocked(() -> MultiJoinFactory.of((MultiJoinInput[])multiJoinInputs).table());
    }
}

