/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.util.TableTools;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.MergeTablesRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MergeTablesGrpcImpl
extends GrpcTableOperation<MergeTablesRequest> {
    @Inject
    public MergeTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionMergeTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getMerge, MergeTablesRequest::getResultId, MergeTablesRequest::getSourceIdsList);
    }

    @Override
    public void validateRequest(MergeTablesRequest request) throws StatusRuntimeException {
        if (request.getSourceIdsList().isEmpty()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Cannot merge zero source tables.");
        }
    }

    @Override
    public Table create(MergeTablesRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Table result;
        Assert.gt((int)sourceTables.size(), (String)"sourceTables.size()", (int)0);
        String keyColumn = request.getKeyColumn();
        List tables = sourceTables.stream().map(SessionState.ExportObject::get).collect(Collectors.toList());
        if (tables.stream().noneMatch(Table::isRefreshing)) {
            return keyColumn.isEmpty() ? TableTools.merge(tables) : TableTools.mergeSorted((String)keyColumn, tables);
        }
        UpdateGraph updateGraph = ((Table)tables.get(0)).getUpdateGraph((NotificationQueue.Dependency[])tables.toArray(Table[]::new));
        try (SafeCloseable ignored = updateGraph.sharedLock().lockCloseable();){
            result = TableTools.merge(tables);
        }
        if (!keyColumn.isEmpty()) {
            result = (Table)result.sort(new String[]{keyColumn});
        }
        return result;
    }
}

