/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.api.AsOfJoinMatch;
import io.deephaven.api.AsOfJoinRule;
import io.deephaven.api.ColumnName;
import io.deephaven.api.NaturalJoinType;
import io.deephaven.api.expression.ExpressionException;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.MatchPair;
import io.deephaven.engine.table.impl.select.MatchPairFactory;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.proto.backplane.grpc.AsOfJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.CrossJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.ExactJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.LeftJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.NaturalJoinTablesRequest;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

public abstract class JoinTablesGrpcImpl<T>
extends GrpcTableOperation<T> {
    private final Function<T, List<String>> getColMatchList;
    private final Function<T, List<String>> getColAddList;
    private final RealTableOperation<T> realTableOperation;

    protected JoinTablesGrpcImpl(GrpcTableOperation.PermissionFunction<T> permission, Function<BatchTableRequest.Operation, T> getRequest, Function<T, Ticket> getTicket, GrpcTableOperation.MultiDependencyFunction<T> getDependencies, Function<T, List<String>> getColMatchList, Function<T, List<String>> getColAddList, RealTableOperation<T> realTableOperation) {
        super(permission, getRequest, getTicket, getDependencies);
        this.getColMatchList = getColMatchList;
        this.getColAddList = getColAddList;
        this.realTableOperation = realTableOperation;
    }

    @Override
    public void validateRequest(T request) throws StatusRuntimeException {
        try {
            MatchPairFactory.getExpressions((Collection)this.getColMatchList.apply(request));
            MatchPairFactory.getExpressions((Collection)this.getColAddList.apply(request));
        }
        catch (ExpressionException err) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)(err.getMessage() + ": " + err.getProblemExpression()));
        }
    }

    @Override
    public Table create(T request, List<SessionState.ExportObject<Table>> sourceTables) {
        MatchPair[] columnsToAdd;
        MatchPair[] columnsToMatch;
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)2);
        try {
            columnsToMatch = MatchPairFactory.getExpressions((Collection)this.getColMatchList.apply(request));
            columnsToAdd = MatchPairFactory.getExpressions((Collection)this.getColAddList.apply(request));
        }
        catch (ExpressionException err) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)(err.getMessage() + ": " + err.getProblemExpression()));
        }
        Table lhs = sourceTables.get(0).get();
        Table rhs = sourceTables.get(1).get();
        Table result = !lhs.isRefreshing() && !rhs.isRefreshing() ? this.realTableOperation.apply(lhs, rhs, columnsToMatch, columnsToAdd, request) : (Table)lhs.getUpdateGraph(new NotificationQueue.Dependency[]{rhs}).sharedLock().computeLocked(() -> this.realTableOperation.apply(lhs, rhs, columnsToMatch, columnsToAdd, request));
        return result;
    }

    @FunctionalInterface
    protected static interface RealTableOperation<T> {
        public Table apply(Table var1, Table var2, MatchPair[] var3, MatchPair[] var4, T var5);
    }

    @Singleton
    public static class NaturalJoinTablesGrpcImpl
    extends JoinTablesGrpcImpl<NaturalJoinTablesRequest> {
        private static final GrpcTableOperation.MultiDependencyFunction<NaturalJoinTablesRequest> EXTRACT_DEPS = request -> List.of(request.getLeftId(), request.getRightId());

        @Inject
        public NaturalJoinTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionNaturalJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getNaturalJoin, NaturalJoinTablesRequest::getResultId, EXTRACT_DEPS, NaturalJoinTablesRequest::getColumnsToMatchList, NaturalJoinTablesRequest::getColumnsToAddList, NaturalJoinTablesGrpcImpl::doJoin);
        }

        public static NaturalJoinType adapt(NaturalJoinTablesRequest.JoinType joinType) {
            switch (joinType) {
                case JOIN_TYPE_NOT_SPECIFIED: 
                case ERROR_ON_DUPLICATE: {
                    return NaturalJoinType.ERROR_ON_DUPLICATE;
                }
                case FIRST_MATCH: {
                    return NaturalJoinType.FIRST_MATCH;
                }
                case LAST_MATCH: {
                    return NaturalJoinType.LAST_MATCH;
                }
                case EXACTLY_ONE_MATCH: {
                    return NaturalJoinType.EXACTLY_ONE_MATCH;
                }
            }
            throw new IllegalArgumentException("Unsupported join type: " + String.valueOf(joinType));
        }

        public static Table doJoin(Table lhs, Table rhs, MatchPair[] columnsToMatch, MatchPair[] columnsToAdd, NaturalJoinTablesRequest request) {
            return (Table)lhs.naturalJoin((Object)rhs, Arrays.asList(columnsToMatch), Arrays.asList(columnsToAdd), NaturalJoinTablesGrpcImpl.adapt(request.getJoinType()));
        }
    }

    @Singleton
    public static class LeftJoinTablesGrpcImpl
    extends JoinTablesGrpcImpl<LeftJoinTablesRequest> {
        private static final GrpcTableOperation.MultiDependencyFunction<LeftJoinTablesRequest> EXTRACT_DEPS = request -> List.of(request.getLeftId(), request.getRightId());

        @Inject
        public LeftJoinTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionLeftJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getLeftJoin, LeftJoinTablesRequest::getResultId, EXTRACT_DEPS, LeftJoinTablesRequest::getColumnsToMatchList, LeftJoinTablesRequest::getColumnsToAddList, LeftJoinTablesGrpcImpl::doJoin);
        }

        public static Table doJoin(Table lhs, Table rhs, MatchPair[] columnsToMatch, MatchPair[] columnsToAdd, LeftJoinTablesRequest request) {
            throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)"LeftJoinTables is currently unimplemented");
        }
    }

    @Singleton
    public static class ExactJoinTablesGrpcImpl
    extends JoinTablesGrpcImpl<ExactJoinTablesRequest> {
        private static final GrpcTableOperation.MultiDependencyFunction<ExactJoinTablesRequest> EXTRACT_DEPS = request -> List.of(request.getLeftId(), request.getRightId());

        @Inject
        public ExactJoinTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionExactJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getExactJoin, ExactJoinTablesRequest::getResultId, EXTRACT_DEPS, ExactJoinTablesRequest::getColumnsToMatchList, ExactJoinTablesRequest::getColumnsToAddList, ExactJoinTablesGrpcImpl::doJoin);
        }

        public static Table doJoin(Table lhs, Table rhs, MatchPair[] columnsToMatch, MatchPair[] columnsToAdd, ExactJoinTablesRequest request) {
            return (Table)lhs.exactJoin((Object)rhs, Arrays.asList(columnsToMatch), Arrays.asList(columnsToAdd));
        }
    }

    @Singleton
    public static class CrossJoinTablesGrpcImpl
    extends JoinTablesGrpcImpl<CrossJoinTablesRequest> {
        private static final GrpcTableOperation.MultiDependencyFunction<CrossJoinTablesRequest> EXTRACT_DEPS = request -> List.of(request.getLeftId(), request.getRightId());

        @Inject
        public CrossJoinTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionCrossJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getCrossJoin, CrossJoinTablesRequest::getResultId, EXTRACT_DEPS, CrossJoinTablesRequest::getColumnsToMatchList, CrossJoinTablesRequest::getColumnsToAddList, CrossJoinTablesGrpcImpl::doJoin);
        }

        public static Table doJoin(Table lhs, Table rhs, MatchPair[] columnsToMatch, MatchPair[] columnsToAdd, CrossJoinTablesRequest request) {
            List<MatchPair> match = Arrays.asList(columnsToMatch);
            List<MatchPair> add = Arrays.asList(columnsToAdd);
            int reserveBits = request.getReserveBits();
            if (reserveBits <= 0) {
                return (Table)lhs.join((Object)rhs, match, add);
            }
            return (Table)lhs.join((Object)rhs, match, add, reserveBits);
        }
    }

    @Singleton
    @Deprecated
    public static class AsOfJoinTablesGrpcImpl
    extends JoinTablesGrpcImpl<AsOfJoinTablesRequest> {
        private static final GrpcTableOperation.MultiDependencyFunction<AsOfJoinTablesRequest> EXTRACT_DEPS = request -> List.of(request.getLeftId(), request.getRightId());

        @Inject
        protected AsOfJoinTablesGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionAsOfJoinTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getAsOfJoin, AsOfJoinTablesRequest::getResultId, EXTRACT_DEPS, AsOfJoinTablesRequest::getColumnsToMatchList, AsOfJoinTablesRequest::getColumnsToAddList, AsOfJoinTablesGrpcImpl::doJoin);
        }

        @Override
        public void validateRequest(AsOfJoinTablesRequest request) throws StatusRuntimeException {
            super.validateRequest(request);
            if (request.getAsOfMatchRule() == AsOfJoinTablesRequest.MatchRule.UNRECOGNIZED) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Unrecognized as-of match rule");
            }
        }

        public static Table doJoin(Table lhs, Table rhs, MatchPair[] columnsToMatch, MatchPair[] columnsToAdd, AsOfJoinTablesRequest request) {
            MatchPair joinMatch = columnsToMatch[columnsToMatch.length - 1];
            return (Table)lhs.asOfJoin((Object)rhs, Arrays.asList(columnsToMatch).subList(0, columnsToMatch.length - 1), AsOfJoinMatch.of((ColumnName)joinMatch.left(), (AsOfJoinRule)AsOfJoinTablesGrpcImpl.adapt(request.getAsOfMatchRule()), (ColumnName)joinMatch.right()), Arrays.asList(columnsToAdd));
        }

        private static AsOfJoinRule adapt(AsOfJoinTablesRequest.MatchRule rule) {
            switch (rule) {
                case LESS_THAN_EQUAL: {
                    return AsOfJoinRule.GREATER_THAN_EQUAL;
                }
                case LESS_THAN: {
                    return AsOfJoinRule.GREATER_THAN;
                }
                case GREATER_THAN_EQUAL: {
                    return AsOfJoinRule.LESS_THAN_EQUAL;
                }
                case GREATER_THAN: {
                    return AsOfJoinRule.LESS_THAN;
                }
            }
            throw new RuntimeException("Unsupported join type: " + String.valueOf(rule));
        }
    }
}

