/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.api.TableOperations;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.HeadOrTailRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

public abstract class HeadOrTailGrpcImpl
extends GrpcTableOperation<HeadOrTailRequest> {
    private final RealTableOperation realTableOperation;

    protected HeadOrTailGrpcImpl(GrpcTableOperation.PermissionFunction<HeadOrTailRequest> permission, Function<BatchTableRequest.Operation, HeadOrTailRequest> getRequest, RealTableOperation realTableOperation) {
        super(permission, getRequest, HeadOrTailRequest::getResultId, HeadOrTailRequest::getSourceId);
        this.realTableOperation = realTableOperation;
    }

    @Override
    public void validateRequest(HeadOrTailRequest request) throws StatusRuntimeException {
        long nRows = request.getNumRows();
        if (nRows < 0L) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("numRows must be >= 0 (found: " + nRows + ")"));
        }
    }

    @Override
    public Table create(HeadOrTailRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table source = sourceTables.get(0).get();
        return this.realTableOperation.apply(source, request.getNumRows());
    }

    @FunctionalInterface
    protected static interface RealTableOperation {
        public Table apply(Table var1, long var2);
    }

    @Singleton
    public static class TailGrpcImpl
    extends HeadOrTailGrpcImpl {
        @Inject
        public TailGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionTail(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getTail, TableOperations::tail);
        }
    }

    @Singleton
    public static class HeadGrpcImpl
    extends HeadOrTailGrpcImpl {
        @Inject
        public HeadGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionHead(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getHead, TableOperations::head);
        }
    }
}

