/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.select.SelectColumn;
import io.deephaven.engine.table.impl.select.SelectColumnFactory;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.HeadOrTailByRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

public abstract class HeadOrTailByGrpcImpl
extends GrpcTableOperation<HeadOrTailByRequest> {
    @NotNull
    private final RealTableOperation realTableOperation;
    @NotNull
    private final ColumnExpressionValidator columnExpressionValidator;

    protected HeadOrTailByGrpcImpl(@NotNull GrpcTableOperation.PermissionFunction<HeadOrTailByRequest> permission, @NotNull Function<BatchTableRequest.Operation, HeadOrTailByRequest> getRequest, @NotNull RealTableOperation realTableOperation, @NotNull ColumnExpressionValidator columnExpressionValidator) {
        super(permission, getRequest, HeadOrTailByRequest::getResultId, HeadOrTailByRequest::getSourceId);
        this.realTableOperation = realTableOperation;
        this.columnExpressionValidator = columnExpressionValidator;
    }

    @Override
    public void validateRequest(HeadOrTailByRequest request) throws StatusRuntimeException {
        long nRows = request.getNumRows();
        if (nRows < 0L) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("numRows must be >= 0 (found: " + nRows + ")"));
        }
    }

    @Override
    public Table create(HeadOrTailByRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        String[] columnSpecs = (String[])request.getGroupByColumnSpecsList().toArray(String[]::new);
        SelectColumn[] expressions = SelectColumnFactory.getExpressions((String[])columnSpecs);
        this.columnExpressionValidator.validateColumnExpressions(expressions, columnSpecs, parent);
        try (SafeCloseable ignored = this.lock(parent);){
            Table table = this.realTableOperation.apply(parent, request.getNumRows(), columnSpecs);
            return table;
        }
    }

    private SafeCloseable lock(Table parent) {
        if (parent.isRefreshing()) {
            UpdateGraph updateGraph = parent.getUpdateGraph();
            return updateGraph.sharedLock().lockCloseable();
        }
        return null;
    }

    @FunctionalInterface
    protected static interface RealTableOperation {
        public Table apply(Table var1, long var2, String[] var4);
    }

    @Singleton
    public static class TailByGrpcImpl
    extends HeadOrTailByGrpcImpl {
        @Inject
        public TailByGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionTailBy(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getTailBy, Table::tailBy, columnExpressionValidator);
        }
    }

    @Singleton
    public static class HeadByGrpcImpl
    extends HeadOrTailByGrpcImpl {
        @Inject
        public HeadByGrpcImpl(TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator columnExpressionValidator) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionHeadBy(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getHeadBy, Table::headBy, columnExpressionValidator);
        }
    }
}

