/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import io.deephaven.auth.AuthContext;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.server.session.SessionState;
import io.grpc.StatusRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class GrpcTableOperation<T> {
    private final PermissionFunction<T> permission;
    private final Function<BatchTableRequest.Operation, T> getRequest;
    private final Function<T, Ticket> getTicket;
    private final MultiDependencyFunction<T> getDependencies;

    protected GrpcTableOperation(PermissionFunction<T> permission, Function<BatchTableRequest.Operation, T> getRequest, Function<T, Ticket> getTicket, MultiDependencyFunction<T> getDependencies) {
        this.permission = permission;
        this.getRequest = getRequest;
        this.getTicket = getTicket;
        this.getDependencies = getDependencies;
    }

    protected GrpcTableOperation(PermissionFunction<T> permission, Function<BatchTableRequest.Operation, T> getRequest, Function<T, Ticket> getTicket, Function<T, TableReference> getDependency) {
        this.permission = permission;
        this.getRequest = getRequest;
        this.getTicket = getTicket;
        this.getDependencies = request -> Collections.singletonList((TableReference)getDependency.apply(request));
    }

    protected GrpcTableOperation(PermissionFunction<T> permission, Function<BatchTableRequest.Operation, T> getRequest, Function<T, Ticket> getTicket) {
        this.permission = permission;
        this.getRequest = getRequest;
        this.getTicket = getTicket;
        this.getDependencies = request -> Collections.emptyList();
    }

    public void validateRequest(T request) throws StatusRuntimeException {
    }

    public abstract Table create(T var1, List<SessionState.ExportObject<Table>> var2);

    public T getRequestFromOperation(BatchTableRequest.Operation op) {
        return this.getRequest.apply(op);
    }

    public Ticket getResultTicket(T request) {
        return this.getTicket.apply(request);
    }

    public List<TableReference> getTableReferences(T request) {
        return this.getDependencies.getTableReferences(request);
    }

    public void checkPermission(T request, List<SessionState.ExportObject<Table>> sourceTables) {
        List<Table> tables = sourceTables.stream().map(SessionState.ExportObject::get).collect(Collectors.toList());
        this.permission.check(ExecutionContext.getContext().getAuthContext(), request, tables);
    }

    @FunctionalInterface
    protected static interface PermissionFunction<T> {
        public void check(AuthContext var1, T var2, List<Table> var3);
    }

    @FunctionalInterface
    protected static interface MultiDependencyFunction<T> {
        public List<TableReference> getTableReferences(T var1);
    }
}

