/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import io.deephaven.api.filter.Filter;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.select.ConditionFilter;
import io.deephaven.engine.table.impl.select.ConjunctiveFilter;
import io.deephaven.engine.table.impl.select.DisjunctiveFilter;
import io.deephaven.engine.table.impl.select.WhereFilter;
import io.deephaven.engine.table.impl.select.WhereFilterInvertedImpl;
import io.deephaven.engine.table.impl.select.WhereFilterSerialImpl;
import io.deephaven.engine.table.impl.select.WhereFilterWithDeclaredBarriersImpl;
import io.deephaven.engine.table.impl.select.WhereFilterWithRespectedBarriersImpl;
import io.deephaven.engine.validation.ColumnExpressionValidator;
import io.deephaven.proto.backplane.grpc.AndCondition;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.Condition;
import io.deephaven.proto.backplane.grpc.FilterTableRequest;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.server.table.ops.filter.ConvertInvalidInExpressions;
import io.deephaven.server.table.ops.filter.FilterFactory;
import io.deephaven.server.table.ops.filter.FlipNonReferenceMatchExpression;
import io.deephaven.server.table.ops.filter.MakeExpressionsNullSafe;
import io.deephaven.server.table.ops.filter.MergeNestedBinaryOperations;
import io.deephaven.server.table.ops.filter.NormalizeNots;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class FilterTableGrpcImpl
extends GrpcTableOperation<FilterTableRequest> {
    @NotNull
    private final ColumnExpressionValidator validator;

    @Inject
    public FilterTableGrpcImpl(@NotNull TableServiceContextualAuthWiring authWiring, @NotNull ColumnExpressionValidator validator) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionFilter(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getFilter, FilterTableRequest::getResultId, FilterTableRequest::getSourceId);
        this.validator = validator;
    }

    @Override
    public Table create(FilterTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table sourceTable = sourceTables.get(0).get();
        List filters = request.getFiltersList();
        if (filters.isEmpty()) {
            return sourceTable;
        }
        List<Condition> finishedConditions = FilterTableGrpcImpl.finishConditions(filters);
        List<WhereFilter> whereFilters = finishedConditions.stream().map(f -> FilterFactory.makeFilter(sourceTable.getDefinition(), f)).collect(Collectors.toList());
        List<ConditionFilter> conditionFilters = FilterTableGrpcImpl.extractConditionFilters(whereFilters);
        this.validator.validateConditionFilters(conditionFilters, sourceTable);
        return (Table)sourceTable.where(Filter.and(whereFilters));
    }

    private static List<ConditionFilter> extractConditionFilters(List<WhereFilter> whereFilters) {
        final ArrayList<ConditionFilter> conditionFilters = new ArrayList<ConditionFilter>();
        WhereFilter.Visitor<Void> visitor = new WhereFilter.Visitor<Void>(){

            public Void visitWhereFilter(WhereFilter filter) {
                if (filter instanceof ConditionFilter) {
                    conditionFilters.add((ConditionFilter)filter);
                    return null;
                }
                return (Void)super.visitWhereFilter(filter);
            }

            public Void visitWhereFilter(WhereFilterInvertedImpl filter) {
                this.visitWhereFilter(filter.getWrappedFilter());
                return null;
            }

            public Void visitWhereFilter(WhereFilterSerialImpl filter) {
                this.visitWhereFilter(filter.getWrappedFilter());
                return null;
            }

            public Void visitWhereFilter(WhereFilterWithDeclaredBarriersImpl filter) {
                this.visitWhereFilter(filter.getWrappedFilter());
                return null;
            }

            public Void visitWhereFilter(WhereFilterWithRespectedBarriersImpl filter) {
                this.visitWhereFilter(filter.getWrappedFilter());
                return null;
            }

            public Void visitWhereFilter(DisjunctiveFilter filter) {
                filter.getFilters().forEach(this::visitWhereFilter);
                return null;
            }

            public Void visitWhereFilter(ConjunctiveFilter filter) {
                filter.getFilters().forEach(this::visitWhereFilter);
                return null;
            }
        };
        whereFilters.forEach(arg_0 -> ((WhereFilter.Visitor)visitor).visitWhereFilter(arg_0));
        return conditionFilters;
    }

    @NotNull
    public static List<Condition> finishConditions(@NotNull List<Condition> filters) {
        Condition filter = filters.size() == 1 ? filters.get(0) : Condition.newBuilder().setAnd(AndCondition.newBuilder().addAllFilters(filters).build()).build();
        filter = NormalizeNots.exec(filter);
        filter = FlipNonReferenceMatchExpression.exec(filter);
        filter = MergeNestedBinaryOperations.exec(filter);
        filter = ConvertInvalidInExpressions.exec(filter);
        filter = MakeExpressionsNullSafe.exec(filter);
        return Collections.singletonList(filter);
    }
}

