/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.util.AppendOnlyArrayBackedInputTable;
import io.deephaven.engine.table.impl.util.KeyedArrayBackedInputTable;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.CreateInputTableRequest;
import io.deephaven.proto.flight.util.SchemaHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.stream.TablePublisher;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flatbuf.Schema;

@Singleton
public class CreateInputTableGrpcImpl
extends GrpcTableOperation<CreateInputTableRequest> {
    private static final GrpcTableOperation.MultiDependencyFunction<CreateInputTableRequest> optionalSourceTable = req -> req.hasSourceTableId() ? Collections.singletonList(req.getSourceTableId()) : Collections.emptyList();
    private static final AtomicInteger blinkTableCount = new AtomicInteger();

    @Inject
    public CreateInputTableGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionCreateInputTable(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getCreateInputTable, CreateInputTableRequest::getResultId, optionalSourceTable);
    }

    @Override
    public void validateRequest(CreateInputTableRequest request) throws StatusRuntimeException {
        if (!request.hasSchema() && !request.hasSourceTableId()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Must specify one of schema and source_table_id");
        }
        if (request.getKind().getKindCase() == null || request.getKind().getKindCase() == CreateInputTableRequest.InputTableKind.KindCase.KIND_NOT_SET) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Unrecognized InputTableKind");
        }
    }

    @Override
    public Table create(CreateInputTableRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        TableDefinition tableDefinitionFromSchema;
        if (request.hasSchema()) {
            Schema schema = SchemaHelper.flatbufSchema((ByteBuffer)request.getSchema().asReadOnlyByteBuffer());
            tableDefinitionFromSchema = BarrageUtil.convertArrowSchema((Schema)schema).tableDef;
        } else if (request.hasSourceTableId()) {
            Table sourceTable = sourceTables.get(0).get();
            tableDefinitionFromSchema = sourceTable.getDefinition();
        } else {
            throw new IllegalStateException("missing schema and source_table_id");
        }
        Table table = CreateInputTableGrpcImpl.create(request, tableDefinitionFromSchema);
        if (!table.hasAttribute("InputTable")) {
            throw new IllegalStateException(String.format("Expected table to have attribute '%s'", "InputTable"));
        }
        return table;
    }

    private static Table create(CreateInputTableRequest request, TableDefinition tableDefinitionFromSchema) {
        CreateInputTableRequest.InputTableKind.KindCase kindCase = request.getKind().getKindCase();
        switch (kindCase) {
            case IN_MEMORY_APPEND_ONLY: {
                return AppendOnlyArrayBackedInputTable.make((TableDefinition)tableDefinitionFromSchema);
            }
            case IN_MEMORY_KEY_BACKED: {
                return KeyedArrayBackedInputTable.make((TableDefinition)tableDefinitionFromSchema, (String[])((String[])request.getKind().getInMemoryKeyBacked().getKeyColumnsList().toArray(String[]::new)));
            }
            case BLINK: {
                String name = CreateInputTableGrpcImpl.class.getSimpleName() + ".BLINK-" + blinkTableCount.getAndIncrement();
                return TablePublisher.of((String)name, (TableDefinition)tableDefinitionFromSchema, null, null).inputTable();
            }
        }
        throw new IllegalStateException("Unsupported input table kind: " + String.valueOf(kindCase));
    }
}

