/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.util.NameValidator;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.ComboAggregateRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ComboAggregateGrpcImpl
extends GrpcTableOperation<ComboAggregateRequest> {
    @Inject
    public ComboAggregateGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionComboAggregate(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getComboAggregate, ComboAggregateRequest::getResultId, ComboAggregateRequest::getSourceId);
    }

    @Override
    public void validateRequest(ComboAggregateRequest request) throws StatusRuntimeException {
        if (request.getAggregatesCount() == 0) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"ComboAggregateRequest incorrectly has zero aggregates provided");
        }
        for (String groupByColumn : request.getGroupByColumnsList()) {
            if (NameValidator.isValidColumnName((String)groupByColumn)) continue;
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"ComboAggregateRequest group by");
        }
        if (this.isSimpleAggregation(request)) {
            ComboAggregateRequest.Aggregate aggregate = request.getAggregates(0);
            if (aggregate.getMatchPairsCount() != 0) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"force_combo is false and only one aggregate provided, but match_pairs is specified");
            }
            if (aggregate.getPercentile() != 0.0) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"force_combo is false and only one aggregate provided, but percentile is specified");
            }
            if (aggregate.getAvgMedian()) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"force_combo is false and only one aggregate provided, but avg_median is specified");
            }
            if (aggregate.getType() != ComboAggregateRequest.AggType.COUNT && aggregate.getType() != ComboAggregateRequest.AggType.WEIGHTED_AVG && !aggregate.getColumnName().isEmpty()) {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"force_combo is false and only one aggregate provided, but column_name is specified for type other than COUNT or WEIGHTED_AVG");
            }
        } else {
            for (ComboAggregateRequest.Aggregate aggregate : request.getAggregatesList()) {
                if (aggregate.getType() != ComboAggregateRequest.AggType.PERCENTILE) {
                    if (aggregate.getPercentile() != 0.0) {
                        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("percentile is specified for type " + String.valueOf(aggregate.getType())));
                    }
                    if (aggregate.getAvgMedian()) {
                        throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("avg_median is specified for type " + String.valueOf(aggregate.getType())));
                    }
                }
                if (aggregate.getType() == ComboAggregateRequest.AggType.COUNT && aggregate.getMatchPairsCount() != 0) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"match_pairs is specified for type COUNT");
                }
                if (aggregate.getType() == ComboAggregateRequest.AggType.COUNT || aggregate.getType() == ComboAggregateRequest.AggType.WEIGHTED_AVG || aggregate.getColumnName().isEmpty()) continue;
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("column_name is specified for type " + String.valueOf(aggregate.getType())));
            }
        }
    }

    private boolean isSimpleAggregation(ComboAggregateRequest request) {
        return !request.getForceCombo() && request.getAggregatesCount() == 1 && request.getAggregates(0).getColumnName().isEmpty() && request.getAggregates(0).getType() != ComboAggregateRequest.AggType.PERCENTILE && request.getAggregates(0).getMatchPairsCount() == 0;
    }

    @Override
    public Table create(ComboAggregateRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table parent = sourceTables.get(0).get();
        ColumnName[] groupByColumns = (ColumnName[])request.getGroupByColumnsList().stream().map(ColumnName::of).toArray(ColumnName[]::new);
        if (this.isSimpleAggregation(request)) {
            return ComboAggregateGrpcImpl.singleAggregateHelper(parent, groupByColumns, request.getAggregates(0));
        }
        return ComboAggregateGrpcImpl.comboAggregateHelper(parent, groupByColumns, request.getAggregatesList());
    }

    private static Table singleAggregateHelper(Table parent, ColumnName[] groupByColumns, ComboAggregateRequest.Aggregate aggregate) {
        switch (aggregate.getType()) {
            case SUM: {
                return (Table)parent.sumBy(groupByColumns);
            }
            case ABS_SUM: {
                return (Table)parent.absSumBy(groupByColumns);
            }
            case GROUP: {
                return (Table)parent.groupBy(Arrays.asList(groupByColumns));
            }
            case AVG: {
                return (Table)parent.avgBy(groupByColumns);
            }
            case COUNT: {
                return (Table)parent.countBy(aggregate.getColumnName(), groupByColumns);
            }
            case FIRST: {
                return (Table)parent.firstBy(groupByColumns);
            }
            case LAST: {
                return (Table)parent.lastBy(groupByColumns);
            }
            case MIN: {
                return (Table)parent.minBy(groupByColumns);
            }
            case MAX: {
                return (Table)parent.maxBy(groupByColumns);
            }
            case MEDIAN: {
                return (Table)parent.medianBy(groupByColumns);
            }
            case STD: {
                return (Table)parent.stdBy(groupByColumns);
            }
            case VAR: {
                return (Table)parent.varBy(groupByColumns);
            }
            case WEIGHTED_AVG: {
                return (Table)parent.wavgBy(aggregate.getColumnName(), groupByColumns);
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregate: " + String.valueOf(aggregate.getType()));
    }

    private static Table comboAggregateHelper(Table parent, ColumnName[] groupByColumns, List<ComboAggregateRequest.Aggregate> aggregates) {
        Set groupByColumnSet = Arrays.stream(groupByColumns).map(ColumnName::name).collect(Collectors.toSet());
        Function<ComboAggregateRequest.Aggregate, String[]> getPairs = agg -> ComboAggregateGrpcImpl.getColumnPairs(parent, groupByColumnSet, agg);
        Collection aggregations = aggregates.stream().map(agg -> ComboAggregateGrpcImpl.makeAggregation(agg, getPairs)).collect(Collectors.toList());
        return (Table)parent.aggBy(aggregations, Arrays.asList(groupByColumns));
    }

    private static String[] getColumnPairs(@NotNull Table parent, @NotNull Set<String> groupByColumnSet, @NotNull ComboAggregateRequest.Aggregate agg) {
        if (agg.getMatchPairsCount() == 0) {
            return (String[])parent.getDefinition().getColumnStream().map(ColumnDefinition::getName).filter(n -> !groupByColumnSet.contains(n) && (agg.getType() != ComboAggregateRequest.AggType.WEIGHTED_AVG || !agg.getColumnName().equals(n))).toArray(String[]::new);
        }
        return (String[])agg.getMatchPairsList().toArray(String[]::new);
    }

    private static Aggregation makeAggregation(@NotNull ComboAggregateRequest.Aggregate agg, @NotNull Function<ComboAggregateRequest.Aggregate, String[]> getPairs) {
        switch (agg.getType()) {
            case SUM: {
                return Aggregation.AggSum((String[])getPairs.apply(agg));
            }
            case ABS_SUM: {
                return Aggregation.AggAbsSum((String[])getPairs.apply(agg));
            }
            case GROUP: {
                return Aggregation.AggGroup((String[])getPairs.apply(agg));
            }
            case AVG: {
                return Aggregation.AggAvg((String[])getPairs.apply(agg));
            }
            case COUNT: {
                return Aggregation.AggCount((String)agg.getColumnName());
            }
            case FIRST: {
                return Aggregation.AggFirst((String[])getPairs.apply(agg));
            }
            case LAST: {
                return Aggregation.AggLast((String[])getPairs.apply(agg));
            }
            case MIN: {
                return Aggregation.AggMin((String[])getPairs.apply(agg));
            }
            case MAX: {
                return Aggregation.AggMax((String[])getPairs.apply(agg));
            }
            case MEDIAN: {
                return Aggregation.AggMed((String[])getPairs.apply(agg));
            }
            case PERCENTILE: {
                return Aggregation.AggPct((double)agg.getPercentile(), (boolean)agg.getAvgMedian(), (String[])getPairs.apply(agg));
            }
            case STD: {
                return Aggregation.AggStd((String[])getPairs.apply(agg));
            }
            case VAR: {
                return Aggregation.AggVar((String[])getPairs.apply(agg));
            }
            case WEIGHTED_AVG: {
                return Aggregation.AggWAvg((String)agg.getColumnName(), (String[])getPairs.apply(agg));
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregate: " + String.valueOf(agg.getType()));
    }
}

