/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.NotificationStepSource;
import io.deephaven.engine.table.impl.remote.ConstructSnapshot;
import io.deephaven.engine.table.impl.sources.ReinterpretUtils;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.ColumnStatisticsRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.server.table.stats.CharacterChunkedStats;
import io.deephaven.server.table.stats.ChunkedNumericalStatsKernel;
import io.deephaven.server.table.stats.ChunkedStatsKernel;
import io.deephaven.server.table.stats.DateTimeChunkedStats;
import io.deephaven.server.table.stats.ObjectChunkedStats;
import io.deephaven.util.type.NumericTypeUtils;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

@Singleton
public class ColumnStatisticsGrpcImpl
extends GrpcTableOperation<ColumnStatisticsRequest> {
    private static final int DEFAULT_UNIQUE_LIMIT = Configuration.getInstance().getIntegerWithDefault("ColumnStatistics.defaultUniqueLimit", 20);
    private static final int MAX_UNIQUE_LIMIT = Configuration.getInstance().getIntegerWithDefault("ColumnStatistics.maxUniqueLimit", 200);
    private static final int MAX_UNIQUE_TO_COLLECT = Configuration.getInstance().getIntegerWithDefault("ColumnStatistics.maxUniqueToCollect", 1000000);

    @Inject
    public ColumnStatisticsGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionComputeColumnStatistics(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getColumnStatistics, ColumnStatisticsRequest::getResultId, ColumnStatisticsRequest::getSourceId);
    }

    @Override
    public Table create(ColumnStatisticsRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        ColumnSource columnSource;
        ChunkedStatsKernel statsFunc;
        Table table = sourceTables.get(0).get().coalesce();
        String columnName = request.getColumnName();
        ColumnDefinition column = table.getDefinition().getColumn(columnName);
        if (column == null) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Table doesn't have a column with the specified name");
        }
        Class type = column.getDataType();
        if (type == Instant.class) {
            statsFunc = new DateTimeChunkedStats();
            columnSource = ReinterpretUtils.instantToLongSource((ColumnSource)table.getColumnSource(columnName));
        } else if (type == ZonedDateTime.class) {
            statsFunc = new DateTimeChunkedStats();
            columnSource = ReinterpretUtils.zonedDateTimeToLongSource((ColumnSource)table.getColumnSource(columnName));
        } else if (NumericTypeUtils.isNumeric((Class)type)) {
            statsFunc = ChunkedNumericalStatsKernel.makeChunkedNumericalStats(type);
            columnSource = table.getColumnSource(columnName);
        } else {
            int maxUnique = request.hasUniqueValueLimit() ? Math.min(request.getUniqueValueLimit(), MAX_UNIQUE_LIMIT) : DEFAULT_UNIQUE_LIMIT;
            statsFunc = type == Character.class || type == Character.TYPE ? new CharacterChunkedStats(MAX_UNIQUE_TO_COLLECT, maxUnique) : new ObjectChunkedStats(MAX_UNIQUE_TO_COLLECT, maxUnique);
            columnSource = table.getColumnSource(columnName);
        }
        MutableObject resultHolder = new MutableObject();
        ConstructSnapshot.callDataSnapshotFunction((String)"GenerateColumnStats()", (ConstructSnapshot.SnapshotControl)ConstructSnapshot.makeSnapshotControl((boolean)false, (boolean)table.isRefreshing(), (NotificationStepSource)((NotificationStepSource)table)), (arg_0, arg_1) -> ColumnStatisticsGrpcImpl.lambda$create$0(table, (Mutable)resultHolder, statsFunc, columnSource, arg_0, arg_1));
        return (Table)resultHolder.getValue();
    }

    private static /* synthetic */ boolean lambda$create$0(Table table, Mutable resultHolder, ChunkedStatsKernel statsFunc, ColumnSource columnSource, boolean usePrev, long beforeClockValue) {
        TrackingRowSet rowSet = usePrev ? table.getRowSet().prev() : table.getRowSet();
        resultHolder.setValue((Object)statsFunc.processChunks((RowSet)rowSet, columnSource, usePrev));
        return true;
    }
}

