/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.ProtocolStringList;
import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.preview.ColumnPreviewManager;
import io.deephaven.proto.backplane.grpc.ApplyPreviewColumnsRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ApplyPreviewColumnsGrpcImpl
extends GrpcTableOperation<ApplyPreviewColumnsRequest> {
    @Inject
    protected ApplyPreviewColumnsGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionApplyPreviewColumns(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getApplyPreviewColumns, ApplyPreviewColumnsRequest::getResultId, ApplyPreviewColumnsRequest::getSourceId);
    }

    @Override
    public void validateRequest(ApplyPreviewColumnsRequest request) throws StatusRuntimeException {
        super.validateRequest(request);
        if (request.getUnpreviewedTypesList().isEmpty() && request.getConvertArrays()) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"convert_arrays is true but no types were provided");
        }
    }

    @Override
    public Table create(ApplyPreviewColumnsRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Table source = sourceTables.get(0).get();
        ProtocolStringList unpreviewedTypes = request.getUnpreviewedTypesList();
        if (unpreviewedTypes.isEmpty()) {
            return ColumnPreviewManager.applyPreview((Table)source);
        }
        boolean convertArrays = request.getConvertArrays();
        return ColumnPreviewManager.applyPreview((Table)source, (boolean)convertArrays, (List)unpreviewedTypes);
    }
}

