/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.AsOfJoinMatch;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.proto.backplane.grpc.AjRajTablesRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

public abstract class AjRajGrpcImpl
extends GrpcTableOperation<AjRajTablesRequest> {
    private final Function<String, AsOfJoinMatch> joinMatchParser;

    private AjRajGrpcImpl(GrpcTableOperation.PermissionFunction<AjRajTablesRequest> permission, Function<BatchTableRequest.Operation, AjRajTablesRequest> getRequest, Function<String, AsOfJoinMatch> joinMatchParser) {
        super(permission, getRequest, AjRajTablesRequest::getResultId, AjRajGrpcImpl::refs);
        this.joinMatchParser = Objects.requireNonNull(joinMatchParser);
    }

    @Override
    public void validateRequest(AjRajTablesRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        GrpcErrorHelper.checkHasField((Message)request, 5);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getLeftId());
        Common.validate(request.getRightId());
        try {
            for (String exactMatch : request.getExactMatchColumnsList()) {
                JoinMatch.parse((String)exactMatch);
            }
            this.joinMatchParser.apply(request.getAsOfColumn());
            for (String addColumn : request.getColumnsToAddList()) {
                JoinAddition.parse((String)addColumn);
            }
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)e.getMessage());
        }
    }

    @Override
    public Table create(AjRajTablesRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)2);
        Table left = sourceTables.get(0).get();
        Table right = sourceTables.get(1).get();
        List exactMatches = JoinMatch.from((Collection)request.getExactMatchColumnsList());
        List columnsToAdd = JoinAddition.from((Collection)request.getColumnsToAddList());
        AsOfJoinMatch asOfMatch = this.joinMatchParser.apply(request.getAsOfColumn());
        try (SafeCloseable _lock = this.lock(left, right);){
            Table table = (Table)left.asOfJoin((Object)right, (Collection)exactMatches, asOfMatch, (Collection)columnsToAdd);
            return table;
        }
    }

    private SafeCloseable lock(Table left, Table right) {
        if (left.isRefreshing() || right.isRefreshing()) {
            return left.getUpdateGraph(new NotificationQueue.Dependency[]{right}).sharedLock().lockCloseable();
        }
        return null;
    }

    private static List<TableReference> refs(AjRajTablesRequest request) {
        return List.of(request.getLeftId(), request.getRightId());
    }

    @Singleton
    public static class RajGrpcImpl
    extends AjRajGrpcImpl {
        @Inject
        public RajGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionRajTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getRaj, AsOfJoinMatch::parseForRaj);
        }
    }

    @Singleton
    public static class AjGrpcImpl
    extends AjRajGrpcImpl {
        @Inject
        public AjGrpcImpl(TableServiceContextualAuthWiring authWiring) {
            super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionAjTables(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getAj, AsOfJoinMatch::parseForAj);
        }
    }
}

