/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.Selectable;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.CountWhere;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.Formula;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Partition;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.proto.backplane.grpc.Aggregation;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.table.ops.AggSpecAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class AggregationAdapter {
    public static void validate(Aggregation aggregation) {
        GrpcErrorHelper.checkHasOneOf((Message)aggregation, "type");
        GrpcErrorHelper.checkHasNoUnknownFields((Message)aggregation);
        Singleton.INSTANCE.adapters().validate(aggregation);
    }

    public static Selectable adapt(io.deephaven.proto.backplane.grpc.Selectable selectable) {
        switch (selectable.getTypeCase()) {
            case RAW: {
                return Selectable.parse((String)selectable.getRaw());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported Selectable type (%s) in Aggregation.", selectable.getTypeCase()));
    }

    public static io.deephaven.api.agg.Aggregation adapt(Aggregation aggregation) {
        return Singleton.INSTANCE.adapters().adapt(aggregation);
    }

    public static void validate(Aggregation.AggregationColumns columns) {
        GrpcErrorHelper.checkHasField((Message)columns, 1);
        GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)columns, 2);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)columns);
        AggSpecAdapter.validate(columns.getSpec());
    }

    public static io.deephaven.api.agg.Aggregation adapt(Aggregation.AggregationColumns aggregationColumns) {
        AggSpec spec = AggSpecAdapter.adapt(aggregationColumns.getSpec());
        return io.deephaven.api.agg.Aggregation.of((AggSpec)spec, (List)aggregationColumns.getMatchPairsList());
    }

    public static Count adapt(Aggregation.AggregationCount count) {
        return io.deephaven.api.agg.Aggregation.AggCount((String)count.getColumnName());
    }

    public static CountWhere adapt(Aggregation.AggregationCountWhere count) {
        return io.deephaven.api.agg.Aggregation.AggCountWhere((String)count.getColumnName(), (String[])((String[])count.getFiltersList().toArray(String[]::new)));
    }

    public static Formula adapt(Aggregation.AggregationFormula formula) {
        return Formula.of((Selectable)AggregationAdapter.adapt(formula.getSelectable()));
    }

    public static FirstRowKey adaptFirst(Aggregation.AggregationRowKey key) {
        return io.deephaven.api.agg.Aggregation.AggFirstRowKey((String)key.getColumnName());
    }

    public static LastRowKey adaptLast(Aggregation.AggregationRowKey key) {
        return io.deephaven.api.agg.Aggregation.AggLastRowKey((String)key.getColumnName());
    }

    public static Partition adapt(Aggregation.AggregationPartition partition) {
        return io.deephaven.api.agg.Aggregation.AggPartition((String)partition.getColumnName(), (boolean)partition.getIncludeGroupByColumns());
    }

    static enum Singleton {
        INSTANCE;

        private final Adapters adapters = new Adapters();

        private Singleton() {
            io.deephaven.api.agg.Aggregation.visitAll((Aggregation.Visitor)this.adapters);
        }

        Adapters adapters() {
            return this.adapters;
        }
    }

    static class Adapters
    implements Aggregation.Visitor {
        final Map<Aggregation.TypeCase, Adapter<?, ?>> adapters = new HashMap();
        final Set<Aggregation.TypeCase> unimplemented = new HashSet<Aggregation.TypeCase>();

        Adapters() {
        }

        public void validate(Aggregation aggregation) {
            this.get(aggregation.getTypeCase()).validate(aggregation);
        }

        public io.deephaven.api.agg.Aggregation adapt(Aggregation aggregation) {
            return this.get(aggregation.getTypeCase()).adapt(aggregation);
        }

        private Adapter<?, ?> get(Aggregation.TypeCase type) {
            Adapter<?, ?> adapter = this.adapters.get(type);
            if (adapter != null) {
                return adapter;
            }
            if (this.unimplemented.contains(type)) {
                throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)String.format("Aggregation type %s is unimplemented", type));
            }
            throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Server is missing Aggregation type %s", type));
        }

        private <I extends Message, T extends io.deephaven.api.agg.Aggregation> void add(Aggregation.TypeCase typeCase, Class<I> iClazz, Class<T> tClazz, Consumer<I> validator, Function<I, T> adapter) {
            try {
                if (this.adapters.put(typeCase, Adapter.create(typeCase, iClazz, validator, adapter)) != null) {
                    throw new IllegalStateException("Adapters have been constructed incorrectly");
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Adapters logical error", e);
            }
        }

        public void visit(Aggregations aggregations) {
        }

        public void visit(ColumnAggregation columnAgg) {
        }

        public void visit(ColumnAggregations columnAggs) {
            this.add(Aggregation.TypeCase.COLUMNS, Aggregation.AggregationColumns.class, io.deephaven.api.agg.Aggregation.class, AggregationAdapter::validate, AggregationAdapter::adapt);
        }

        public void visit(Count count) {
            this.add(Aggregation.TypeCase.COUNT, Aggregation.AggregationCount.class, Count.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adapt);
        }

        public void visit(CountWhere countWhere) {
            this.add(Aggregation.TypeCase.COUNT_WHERE, Aggregation.AggregationCountWhere.class, CountWhere.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adapt);
        }

        public void visit(FirstRowKey firstRowKey) {
            this.add(Aggregation.TypeCase.FIRST_ROW_KEY, Aggregation.AggregationRowKey.class, FirstRowKey.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adaptFirst);
        }

        public void visit(LastRowKey lastRowKey) {
            this.add(Aggregation.TypeCase.LAST_ROW_KEY, Aggregation.AggregationRowKey.class, LastRowKey.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adaptLast);
        }

        public void visit(Partition partition) {
            this.add(Aggregation.TypeCase.PARTITION, Aggregation.AggregationPartition.class, Partition.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adapt);
        }

        public void visit(Formula formula) {
            this.add(Aggregation.TypeCase.FORMULA, Aggregation.AggregationFormula.class, Formula.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggregationAdapter::adapt);
        }
    }

    private static class Adapter<I extends Message, T extends io.deephaven.api.agg.Aggregation> {
        private final Descriptors.FieldDescriptor field;
        private final Consumer<I> validator;
        private final Function<I, T> adapter;

        public static <I extends Message, T extends io.deephaven.api.agg.Aggregation> Adapter<I, T> create(Aggregation.TypeCase typeCase, Class<I> clazz, Consumer<I> validator, Function<I, T> adapter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Descriptors.FieldDescriptor field = GrpcErrorHelper.extractField(Aggregation.getDescriptor(), typeCase.getNumber(), clazz);
            return new Adapter<I, T>(field, validator, adapter);
        }

        private Adapter(Descriptors.FieldDescriptor field, Consumer<I> validator, Function<I, T> adapter) {
            this.field = field;
            this.validator = Objects.requireNonNull(validator);
            this.adapter = Objects.requireNonNull(adapter);
        }

        public void validate(Aggregation aggregation) {
            this.validator.accept((Message)aggregation.getField(this.field));
        }

        public T adapt(Aggregation aggregation) {
            return (T)((io.deephaven.api.agg.Aggregation)this.adapter.apply((Message)aggregation.getField(this.field)));
        }
    }
}

