/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import io.deephaven.api.ColumnName;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.AggregateRequest;
import io.deephaven.proto.backplane.grpc.Aggregation;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.proto.backplane.grpc.TableReference;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.AggregationAdapter;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class AggregateGrpcImpl
extends GrpcTableOperation<AggregateRequest> {
    private static List<TableReference> refs(AggregateRequest request) {
        return request.hasInitialGroupsId() ? List.of(request.getSourceId(), request.getInitialGroupsId()) : List.of(request.getSourceId());
    }

    @Inject
    public AggregateGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionAggregate(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getAggregate, AggregateRequest::getResultId, AggregateGrpcImpl::refs);
    }

    @Override
    public void validateRequest(AggregateRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkRepeatedFieldNonEmpty((Message)request, 5);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getSourceId());
        if (request.hasInitialGroupsId()) {
            Common.validate(request.getInitialGroupsId());
        }
        for (Aggregation aggregation : request.getAggregationsList()) {
            AggregationAdapter.validate(aggregation);
        }
    }

    @Override
    public Table create(AggregateRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)(request.hasInitialGroupsId() ? 2 : 1));
        Assert.gtZero((int)request.getAggregationsCount(), (String)"request.getAggregationsCount()");
        Table parent = sourceTables.get(0).get();
        Table initialGroups = request.hasInitialGroupsId() ? sourceTables.get(1).get() : null;
        List aggregations = request.getAggregationsList().stream().map(AggregationAdapter::adapt).collect(Collectors.toList());
        List groupByColumns = ColumnName.from((Collection)request.getGroupByColumnsList());
        return (Table)parent.aggBy(aggregations, request.getPreserveEmpty(), (Object)initialGroups, (Collection)groupByColumns);
    }
}

