/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Message;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.auth.codegen.impl.TableServiceContextualAuthWiring;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.AggSpec;
import io.deephaven.proto.backplane.grpc.AggregateAllRequest;
import io.deephaven.proto.backplane.grpc.BatchTableRequest;
import io.deephaven.server.grpc.Common;
import io.deephaven.server.grpc.GrpcErrorHelper;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.table.ops.AggSpecAdapter;
import io.deephaven.server.table.ops.GrpcTableOperation;
import io.grpc.StatusRuntimeException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class AggregateAllGrpcImpl
extends GrpcTableOperation<AggregateAllRequest> {
    @Inject
    public AggregateAllGrpcImpl(TableServiceContextualAuthWiring authWiring) {
        super((arg_0, arg_1, arg_2) -> ((TableServiceContextualAuthWiring)authWiring).checkPermissionAggregateAll(arg_0, arg_1, arg_2), BatchTableRequest.Operation::getAggregateAll, AggregateAllRequest::getResultId, AggregateAllRequest::getSourceId);
    }

    @Override
    public void validateRequest(AggregateAllRequest request) throws StatusRuntimeException {
        GrpcErrorHelper.checkHasField((Message)request, 2);
        GrpcErrorHelper.checkHasField((Message)request, 3);
        GrpcErrorHelper.checkHasNoUnknownFields((Message)request);
        Common.validate(request.getSourceId());
        AggSpecAdapter.validate(request.getSpec());
    }

    @Override
    public Table create(AggregateAllRequest request, List<SessionState.ExportObject<Table>> sourceTables) {
        Assert.eq((int)sourceTables.size(), (String)"sourceTables.size()", (int)1);
        Assert.eqTrue((boolean)request.hasSpec(), (String)"request.hasSpec()");
        Assert.neq((Object)request.getSpec().getTypeCase(), (String)"request.getSpec().getTypeCase()", (Object)AggSpec.TypeCase.TYPE_NOT_SET);
        Table parent = sourceTables.get(0).get();
        AggSpec spec = AggSpecAdapter.adapt(request.getSpec());
        return (Table)parent.aggAllBy(spec, (Collection)request.getGroupByColumnsList());
    }
}

