/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.ops;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import io.deephaven.api.ColumnName;
import io.deephaven.api.SortColumn;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecAbsSum;
import io.deephaven.api.agg.spec.AggSpecApproximatePercentile;
import io.deephaven.api.agg.spec.AggSpecAvg;
import io.deephaven.api.agg.spec.AggSpecCountDistinct;
import io.deephaven.api.agg.spec.AggSpecDistinct;
import io.deephaven.api.agg.spec.AggSpecFirst;
import io.deephaven.api.agg.spec.AggSpecFormula;
import io.deephaven.api.agg.spec.AggSpecFreeze;
import io.deephaven.api.agg.spec.AggSpecGroup;
import io.deephaven.api.agg.spec.AggSpecLast;
import io.deephaven.api.agg.spec.AggSpecMax;
import io.deephaven.api.agg.spec.AggSpecMedian;
import io.deephaven.api.agg.spec.AggSpecMin;
import io.deephaven.api.agg.spec.AggSpecPercentile;
import io.deephaven.api.agg.spec.AggSpecSortedFirst;
import io.deephaven.api.agg.spec.AggSpecSortedLast;
import io.deephaven.api.agg.spec.AggSpecStd;
import io.deephaven.api.agg.spec.AggSpecSum;
import io.deephaven.api.agg.spec.AggSpecTDigest;
import io.deephaven.api.agg.spec.AggSpecUnique;
import io.deephaven.api.agg.spec.AggSpecVar;
import io.deephaven.api.agg.spec.AggSpecWAvg;
import io.deephaven.api.agg.spec.AggSpecWSum;
import io.deephaven.api.object.UnionObject;
import io.deephaven.proto.backplane.grpc.AggSpec;
import io.deephaven.proto.backplane.grpc.NullValue;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.grpc.GrpcErrorHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class AggSpecAdapter {
    AggSpecAdapter() {
    }

    public static void validate(io.deephaven.proto.backplane.grpc.AggSpec spec) {
        GrpcErrorHelper.checkHasOneOf((Message)spec, "type");
        GrpcErrorHelper.checkHasNoUnknownFields((Message)spec);
        Singleton.INSTANCE.adapters.validate(spec);
    }

    public static void validate(AggSpec.AggSpecUnique aggSpecUnique) {
        GrpcErrorHelper.checkHasNoUnknownFields((Message)aggSpecUnique);
        GrpcErrorHelper.checkHasField((Message)aggSpecUnique, 2);
        AggSpecAdapter.validate(aggSpecUnique.getNonUniqueSentinel());
    }

    public static void validate(AggSpec.AggSpecNonUniqueSentinel nonUniqueSentinel) {
        GrpcErrorHelper.checkHasOneOf((Message)nonUniqueSentinel, "type");
        GrpcErrorHelper.checkHasNoUnknownFieldsRecursive((Message)nonUniqueSentinel);
        AggSpec.AggSpecNonUniqueSentinel.TypeCase type = nonUniqueSentinel.getTypeCase();
        switch (type) {
            case STRING_VALUE: 
            case INT_VALUE: 
            case LONG_VALUE: 
            case FLOAT_VALUE: 
            case DOUBLE_VALUE: 
            case BOOL_VALUE: {
                return;
            }
            case NULL_VALUE: {
                if (nonUniqueSentinel.getNullValue() != NullValue.NULL_VALUE) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"AggSpecNonUniqueSentinel null_value out of range");
                }
                return;
            }
            case BYTE_VALUE: {
                if (nonUniqueSentinel.getByteValue() != (byte)nonUniqueSentinel.getByteValue()) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"AggSpecNonUniqueSentinel byte_value out of range");
                }
                return;
            }
            case SHORT_VALUE: {
                if (nonUniqueSentinel.getShortValue() != (short)nonUniqueSentinel.getShortValue()) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"AggSpecNonUniqueSentinel short_value out of range");
                }
                return;
            }
            case CHAR_VALUE: {
                if (nonUniqueSentinel.getCharValue() != (char)nonUniqueSentinel.getCharValue()) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"AggSpecNonUniqueSentinel char_value out of range");
                }
                return;
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Server missing AggSpecNonUniqueSentinel type %s", type));
    }

    public static AggSpec adapt(io.deephaven.proto.backplane.grpc.AggSpec spec) {
        return Singleton.INSTANCE.adapters.adapt(spec);
    }

    private static AggSpecApproximatePercentile adapt(AggSpec.AggSpecApproximatePercentile percentile) {
        return percentile.hasCompression() ? AggSpec.approximatePercentile((double)percentile.getPercentile(), (double)percentile.getCompression()) : AggSpec.approximatePercentile((double)percentile.getPercentile());
    }

    private static AggSpecCountDistinct adapt(AggSpec.AggSpecCountDistinct countDistinct) {
        return AggSpec.countDistinct((boolean)countDistinct.getCountNulls());
    }

    private static AggSpecDistinct adapt(AggSpec.AggSpecDistinct distinct) {
        return AggSpec.distinct((boolean)distinct.getIncludeNulls());
    }

    private static AggSpecFormula adapt(AggSpec.AggSpecFormula formula) {
        return AggSpec.formula((String)formula.getFormula(), (String)formula.getParamToken());
    }

    private static AggSpecMedian adapt(AggSpec.AggSpecMedian median) {
        return AggSpec.median((boolean)median.getAverageEvenlyDivided());
    }

    private static AggSpecPercentile adapt(AggSpec.AggSpecPercentile percentile) {
        return AggSpec.percentile((double)percentile.getPercentile(), (boolean)percentile.getAverageEvenlyDivided());
    }

    private static SortColumn adapt(AggSpec.AggSpecSortedColumn sortedColumn) {
        return SortColumn.asc((ColumnName)ColumnName.of((String)sortedColumn.getColumnName()));
    }

    private static AggSpecSortedFirst adaptFirst(AggSpec.AggSpecSorted sorted) {
        AggSpecSortedFirst.Builder builder = AggSpecSortedFirst.builder();
        for (AggSpec.AggSpecSortedColumn sortedColumn : sorted.getColumnsList()) {
            builder.addColumns(AggSpecAdapter.adapt(sortedColumn));
        }
        return builder.build();
    }

    private static AggSpecSortedLast adaptLast(AggSpec.AggSpecSorted sorted) {
        AggSpecSortedLast.Builder builder = AggSpecSortedLast.builder();
        for (AggSpec.AggSpecSortedColumn sortDescriptor : sorted.getColumnsList()) {
            builder.addColumns(AggSpecAdapter.adapt(sortDescriptor));
        }
        return builder.build();
    }

    private static AggSpecTDigest adapt(AggSpec.AggSpecTDigest tDigest) {
        return tDigest.hasCompression() ? AggSpec.tDigest((double)tDigest.getCompression()) : AggSpec.tDigest();
    }

    private static AggSpecUnique adapt(AggSpec.AggSpecUnique unique) {
        UnionObject nonUniqueSentinel = AggSpecAdapter.adapt(unique.getNonUniqueSentinel());
        return AggSpecUnique.of((boolean)unique.getIncludeNulls(), (UnionObject)nonUniqueSentinel);
    }

    private static UnionObject adapt(AggSpec.AggSpecNonUniqueSentinel nonUniqueSentinel) {
        switch (nonUniqueSentinel.getTypeCase()) {
            case NULL_VALUE: {
                return null;
            }
            case STRING_VALUE: {
                return UnionObject.of((Object)nonUniqueSentinel.getStringValue());
            }
            case INT_VALUE: {
                return UnionObject.of((int)nonUniqueSentinel.getIntValue());
            }
            case LONG_VALUE: {
                return UnionObject.of((long)nonUniqueSentinel.getLongValue());
            }
            case FLOAT_VALUE: {
                return UnionObject.of((float)nonUniqueSentinel.getFloatValue());
            }
            case DOUBLE_VALUE: {
                return UnionObject.of((double)nonUniqueSentinel.getDoubleValue());
            }
            case BOOL_VALUE: {
                return UnionObject.of((boolean)nonUniqueSentinel.getBoolValue());
            }
            case BYTE_VALUE: {
                return UnionObject.of((byte)((byte)nonUniqueSentinel.getByteValue()));
            }
            case SHORT_VALUE: {
                return UnionObject.of((short)((short)nonUniqueSentinel.getShortValue()));
            }
            case CHAR_VALUE: {
                return UnionObject.of((char)((char)nonUniqueSentinel.getCharValue()));
            }
            case TYPE_NOT_SET: {
                throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"AggSpecNonUniqueSentinel type not set");
            }
        }
        throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Server is missing AggSpecNonUniqueSentinel case %s", nonUniqueSentinel.getTypeCase()));
    }

    private static AggSpecWAvg adaptWeightedAvg(AggSpec.AggSpecWeighted weighted) {
        return AggSpec.wavg((String)weighted.getWeightColumn());
    }

    private static AggSpecWSum adaptWeightedSum(AggSpec.AggSpecWeighted weighted) {
        return AggSpec.wsum((String)weighted.getWeightColumn());
    }

    static enum Singleton {
        INSTANCE;

        private final Adapters adapters = new Adapters();

        private Singleton() {
            AggSpec.visitAll((AggSpec.Visitor)this.adapters);
        }

        Adapters adapters() {
            return this.adapters;
        }
    }

    static class Adapters
    implements AggSpec.Visitor {
        final Map<AggSpec.TypeCase, Adapter<?, ?>> adapters = new HashMap();
        final Set<AggSpec.TypeCase> unimplemented = new HashSet<AggSpec.TypeCase>();

        Adapters() {
        }

        public void validate(io.deephaven.proto.backplane.grpc.AggSpec spec) {
            this.get(spec.getTypeCase()).validate(spec);
        }

        public AggSpec adapt(io.deephaven.proto.backplane.grpc.AggSpec spec) {
            return this.get(spec.getTypeCase()).adapt(spec);
        }

        private Adapter<?, ?> get(AggSpec.TypeCase type) {
            Adapter<?, ?> adapter = this.adapters.get(type);
            if (adapter != null) {
                return adapter;
            }
            if (this.unimplemented.contains(type)) {
                throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)String.format("AggSpec type %s is unimplemented", type));
            }
            throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Server is missing AggSpec type %s", type));
        }

        private <I extends Message, T extends AggSpec> void add(AggSpec.TypeCase typeCase, Class<I> iClazz, Class<T> tClazz, Consumer<I> validator, Function<I, T> adapter) {
            try {
                if (this.adapters.put(typeCase, Adapter.create(typeCase, iClazz, validator, adapter)) != null) {
                    throw new IllegalStateException("Adapters have been constructed incorrectly");
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Adapters logical error", e);
            }
        }

        private <I extends Message, T extends AggSpec> void add(AggSpec.TypeCase typeCase, Class<I> iClazz, Class<T> tClazz, Consumer<I> validator, Supplier<T> supplier) {
            this.add(typeCase, iClazz, tClazz, validator, (I m) -> (AggSpec)supplier.get());
        }

        public void visit(AggSpecAbsSum absSum) {
            this.add(AggSpec.TypeCase.ABS_SUM, AggSpec.AggSpecAbsSum.class, AggSpecAbsSum.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::absSum);
        }

        public void visit(AggSpecApproximatePercentile approxPct) {
            this.add(AggSpec.TypeCase.APPROXIMATE_PERCENTILE, AggSpec.AggSpecApproximatePercentile.class, AggSpecApproximatePercentile.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecAvg avg) {
            this.add(AggSpec.TypeCase.AVG, AggSpec.AggSpecAvg.class, AggSpecAvg.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::avg);
        }

        public void visit(AggSpecCountDistinct countDistinct) {
            this.add(AggSpec.TypeCase.COUNT_DISTINCT, AggSpec.AggSpecCountDistinct.class, AggSpecCountDistinct.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecDistinct distinct) {
            this.add(AggSpec.TypeCase.DISTINCT, AggSpec.AggSpecDistinct.class, AggSpecDistinct.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecFirst first) {
            this.add(AggSpec.TypeCase.FIRST, AggSpec.AggSpecFirst.class, AggSpecFirst.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::first);
        }

        public void visit(AggSpecFormula formula) {
            this.add(AggSpec.TypeCase.FORMULA, AggSpec.AggSpecFormula.class, AggSpecFormula.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecFreeze freeze) {
            this.add(AggSpec.TypeCase.FREEZE, AggSpec.AggSpecFreeze.class, AggSpecFreeze.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::freeze);
        }

        public void visit(AggSpecGroup group) {
            this.add(AggSpec.TypeCase.GROUP, AggSpec.AggSpecGroup.class, AggSpecGroup.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::group);
        }

        public void visit(AggSpecLast last) {
            this.add(AggSpec.TypeCase.LAST, AggSpec.AggSpecLast.class, AggSpecLast.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::last);
        }

        public void visit(AggSpecMax max) {
            this.add(AggSpec.TypeCase.MAX, AggSpec.AggSpecMax.class, AggSpecMax.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::max);
        }

        public void visit(AggSpecMedian median) {
            this.add(AggSpec.TypeCase.MEDIAN, AggSpec.AggSpecMedian.class, AggSpecMedian.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecMin min) {
            this.add(AggSpec.TypeCase.MIN, AggSpec.AggSpecMin.class, AggSpecMin.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::min);
        }

        public void visit(AggSpecPercentile pct) {
            this.add(AggSpec.TypeCase.PERCENTILE, AggSpec.AggSpecPercentile.class, AggSpecPercentile.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecSortedFirst sortedFirst) {
            this.add(AggSpec.TypeCase.SORTED_FIRST, AggSpec.AggSpecSorted.class, AggSpecSortedFirst.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adaptFirst(x$0));
        }

        public void visit(AggSpecSortedLast sortedLast) {
            this.add(AggSpec.TypeCase.SORTED_LAST, AggSpec.AggSpecSorted.class, AggSpecSortedLast.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adaptLast(x$0));
        }

        public void visit(AggSpecStd std) {
            this.add(AggSpec.TypeCase.STD, AggSpec.AggSpecStd.class, AggSpecStd.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::std);
        }

        public void visit(AggSpecSum sum) {
            this.add(AggSpec.TypeCase.SUM, AggSpec.AggSpecSum.class, AggSpecSum.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::sum);
        }

        public void visit(AggSpecTDigest tDigest) {
            this.add(AggSpec.TypeCase.T_DIGEST, AggSpec.AggSpecTDigest.class, AggSpecTDigest.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecUnique unique) {
            this.add(AggSpec.TypeCase.UNIQUE, AggSpec.AggSpecUnique.class, AggSpecUnique.class, AggSpecAdapter::validate, (I x$0) -> AggSpecAdapter.adapt(x$0));
        }

        public void visit(AggSpecWAvg wAvg) {
            this.add(AggSpec.TypeCase.WEIGHTED_AVG, AggSpec.AggSpecWeighted.class, AggSpecWAvg.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adaptWeightedAvg(x$0));
        }

        public void visit(AggSpecWSum wSum) {
            this.add(AggSpec.TypeCase.WEIGHTED_SUM, AggSpec.AggSpecWeighted.class, AggSpecWSum.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, (I x$0) -> AggSpecAdapter.adaptWeightedSum(x$0));
        }

        public void visit(AggSpecVar var) {
            this.add(AggSpec.TypeCase.VAR, AggSpec.AggSpecVar.class, AggSpecVar.class, GrpcErrorHelper::checkHasNoUnknownFieldsRecursive, AggSpec::var);
        }
    }

    private static class Adapter<I extends Message, T extends AggSpec> {
        private final Descriptors.FieldDescriptor field;
        private final Consumer<I> validator;
        private final Function<I, T> adapter;

        public static <I extends Message, T extends AggSpec> Adapter<I, T> create(AggSpec.TypeCase typeCase, Class<I> clazz, Consumer<I> validator, Function<I, T> adapter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Descriptors.FieldDescriptor field = GrpcErrorHelper.extractField(io.deephaven.proto.backplane.grpc.AggSpec.getDescriptor(), typeCase.getNumber(), clazz);
            return new Adapter<I, T>(field, validator, adapter);
        }

        private Adapter(Descriptors.FieldDescriptor field, Consumer<I> validator, Function<I, T> adapter) {
            this.field = field;
            this.validator = Objects.requireNonNull(validator);
            this.adapter = Objects.requireNonNull(adapter);
        }

        public void validate(io.deephaven.proto.backplane.grpc.AggSpec spec) {
            this.validator.accept((Message)spec.getField(this.field));
        }

        public T adapt(io.deephaven.proto.backplane.grpc.AggSpec spec) {
            return (T)((AggSpec)this.adapter.apply((Message)spec.getField(this.field)));
        }
    }
}

