/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.table.inputtables;

import com.google.rpc.Code;
import io.deephaven.auth.codegen.impl.InputTableServiceContextualAuthWiring;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.util.input.InputTableStatusListener;
import io.deephaven.engine.util.input.InputTableUpdater;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.AddTableRequest;
import io.deephaven.proto.backplane.grpc.AddTableResponse;
import io.deephaven.proto.backplane.grpc.DeleteTableRequest;
import io.deephaven.proto.backplane.grpc.DeleteTableResponse;
import io.deephaven.proto.backplane.grpc.InputTableServiceGrpc;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.util.SafeCloseable;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class InputTableServiceGrpcImpl
extends InputTableServiceGrpc.InputTableServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(InputTableServiceGrpcImpl.class);
    private final InputTableServiceContextualAuthWiring authWiring;
    private final TicketRouter ticketRouter;
    private final SessionService sessionService;

    @Inject
    public InputTableServiceGrpcImpl(InputTableServiceContextualAuthWiring authWiring, TicketRouter ticketRouter, SessionService sessionService) {
        this.authWiring = authWiring;
        this.ticketRouter = ticketRouter;
        this.sessionService = sessionService;
    }

    public void addTableToInputTable(@NotNull AddTableRequest request, final @NotNull StreamObserver<AddTableResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        String description = "InputTableService#addTableToInputTable(inputTable=" + this.ticketRouter.getLogNameFor(request.getInputTable(), "inputTable") + ", tableToAdd=" + this.ticketRouter.getLogNameFor(request.getTableToAdd(), "tableToAdd") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject targetTable = this.ticketRouter.resolve(session, request.getInputTable(), "inputTable");
            SessionState.ExportObject tableToAddExport = this.ticketRouter.resolve(session, request.getTableToAdd(), "tableToAdd");
            session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).onError(responseObserver).require(targetTable, tableToAddExport).submit(() -> {
                Object inputTableAsObject = ((Table)targetTable.get()).getAttribute("InputTable");
                if (!(inputTableAsObject instanceof InputTableUpdater)) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Table can't be used as an input table");
                }
                InputTableUpdater inputTableUpdater = (InputTableUpdater)inputTableAsObject;
                Table tableToAdd = (Table)tableToAddExport.get();
                this.authWiring.checkPermissionAddTableToInputTable(ExecutionContext.getContext().getAuthContext(), request, List.of((Table)targetTable.get(), tableToAdd));
                try {
                    inputTableUpdater.validateAddOrModify(tableToAdd);
                }
                catch (TableDefinition.IncompatibleTableDefinitionException exception) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Provided tables's columns are not compatible: " + exception.getMessage()));
                }
                inputTableUpdater.addAsync(tableToAdd, new InputTableStatusListener(){

                    public void onSuccess() {
                        GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)AddTableResponse.getDefaultInstance());
                    }

                    public void onError(Throwable t) {
                        GrpcUtil.safelyError((StreamObserver)responseObserver, (StatusRuntimeException)Exceptions.statusRuntimeException((Code)Code.DATA_LOSS, (String)"Error adding table to input table"));
                    }
                });
            });
        }
    }

    public void deleteTableFromInputTable(@NotNull DeleteTableRequest request, final @NotNull StreamObserver<DeleteTableResponse> responseObserver) {
        SessionState session = this.sessionService.getCurrentSession();
        String description = "InputTableService#deleteTableFromInputTable(inputTable=" + this.ticketRouter.getLogNameFor(request.getInputTable(), "inputTable") + ", tableToRemove=" + this.ticketRouter.getLogNameFor(request.getTableToRemove(), "tableToRemove") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject targetTable = this.ticketRouter.resolve(session, request.getInputTable(), "inputTable");
            SessionState.ExportObject tableToRemoveExport = this.ticketRouter.resolve(session, request.getTableToRemove(), "tableToRemove");
            session.nonExport().queryPerformanceRecorder(queryPerformanceRecorder).onError(responseObserver).require(targetTable, tableToRemoveExport).submit(() -> {
                Object inputTableAsObject = ((Table)targetTable.get()).getAttribute("InputTable");
                if (!(inputTableAsObject instanceof InputTableUpdater)) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Table can't be used as an input table");
                }
                InputTableUpdater inputTableUpdater = (InputTableUpdater)inputTableAsObject;
                Table tableToRemove = (Table)tableToRemoveExport.get();
                this.authWiring.checkPermissionDeleteTableFromInputTable(ExecutionContext.getContext().getAuthContext(), request, List.of((Table)targetTable.get(), tableToRemove));
                try {
                    inputTableUpdater.validateDelete(tableToRemove);
                }
                catch (TableDefinition.IncompatibleTableDefinitionException exception) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Provided tables's columns are not compatible: " + exception.getMessage()));
                }
                catch (UnsupportedOperationException exception) {
                    throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Provided input table does not support delete.");
                }
                inputTableUpdater.deleteAsync(tableToRemove, new InputTableStatusListener(){

                    public void onSuccess() {
                        GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)DeleteTableResponse.getDefaultInstance());
                    }

                    public void onError(Throwable t) {
                        GrpcUtil.safelyError((StreamObserver)responseObserver, (StatusRuntimeException)Exceptions.statusRuntimeException((Code)Code.DATA_LOSS, (String)"Error deleting table from inputtable"));
                    }
                });
            });
        }
    }
}

