/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.google.rpc.Code;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.extensions.barrage.util.BarrageUtil;
import io.deephaven.hash.KeyedIntObjectHashMap;
import io.deephaven.hash.KeyedIntObjectKey;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.session.CommandResolver;
import io.deephaven.server.session.PathResolver;
import io.deephaven.server.session.PathResolverPrefixedBase;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolver;
import io.deephaven.server.session.WantsTicketRouter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TicketRouter {
    private final List<TicketResolver> enabledResolvers;
    private final KeyedIntObjectHashMap<TicketResolver> byteResolverMap = new KeyedIntObjectHashMap(RESOLVER_OBJECT_TICKET_ID);
    private final KeyedObjectHashMap<String, PathResolverPrefixedBase> prefixedPathResolverMap = new KeyedObjectHashMap(RESOLVER_OBJECT_DESCRIPTOR_ID);
    private final TicketResolver.Authorization authorization;
    private final Set<CommandResolver> commandResolvers;
    private final Set<PathResolver> genericPathResolvers;
    private static final KeyedIntObjectKey<TicketResolver> RESOLVER_OBJECT_TICKET_ID = new KeyedIntObjectKey.BasicStrict<TicketResolver>(){

        public int getIntKey(TicketResolver ticketResolver) {
            return ticketResolver.ticketRoute();
        }
    };
    private static final KeyedObjectKey<String, PathResolverPrefixedBase> RESOLVER_OBJECT_DESCRIPTOR_ID = new KeyedObjectKey.Basic<String, PathResolverPrefixedBase>(){

        public String getKey(PathResolverPrefixedBase ticketResolver) {
            return ticketResolver.flightDescriptorRoute();
        }
    };

    private static boolean enabled(TicketResolver resolver) {
        String property = TicketResolver.class.getSimpleName() + "." + resolver.getClass().getSimpleName() + ".enabled";
        return Configuration.getInstance().getBooleanWithDefault(property, true);
    }

    @Inject
    public TicketRouter(AuthorizationProvider authorizationProvider, Set<TicketResolver> resolvers) {
        this.enabledResolvers = resolvers.stream().filter(TicketRouter::enabled).collect(Collectors.toList());
        this.authorization = authorizationProvider.getTicketResolverAuthorization();
        this.commandResolvers = this.enabledResolvers.stream().filter(CommandResolver.class::isInstance).map(CommandResolver.class::cast).collect(Collectors.toSet());
        this.genericPathResolvers = this.enabledResolvers.stream().filter(PathResolver.class::isInstance).filter(Predicate.not(PathResolverPrefixedBase.class::isInstance)).map(PathResolver.class::cast).collect(Collectors.toSet());
        for (TicketResolver resolver : this.enabledResolvers) {
            PathResolverPrefixedBase prefixedPathResolver;
            if (resolver.ticketRoute() != 0 && !this.byteResolverMap.add((Object)resolver)) {
                throw new IllegalArgumentException("Duplicate ticket resolver for ticket route " + resolver.ticketRoute());
            }
            if (!(resolver instanceof PathResolverPrefixedBase) || this.prefixedPathResolverMap.add((Object)(prefixedPathResolver = (PathResolverPrefixedBase)resolver))) continue;
            throw new IllegalArgumentException("Duplicate ticket resolver for descriptor route " + prefixedPathResolver.flightDescriptorRoute());
        }
        for (TicketResolver resolver : this.enabledResolvers) {
            if (!(resolver instanceof WantsTicketRouter)) continue;
            ((WantsTicketRouter)((Object)resolver)).setTicketRouter(this);
        }
    }

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteBuffer ticket, String logId) {
        SessionState.ExportObject exportObject;
        block9: {
            if (ticket.remaining() == 0) {
                throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("could not resolve '" + logId + "' it's an empty ticket"));
            }
            String ticketName = this.getLogNameFor(ticket, logId);
            QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("resolveTicket:" + ticketName);
            try {
                exportObject = this.getResolver(ticket.get(ticket.position()), logId).resolve(session, ticket, logId);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    return SessionState.wrapAsFailedExport(e);
                }
            }
            ignored.close();
        }
        return exportObject;
    }

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.Ticket ticket, String logId) {
        return this.resolve(session, ticket.getTicket().asReadOnlyByteBuffer(), logId);
    }

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Ticket ticket, String logId) {
        return this.resolve(session, ticket.getTicket().asReadOnlyByteBuffer(), logId);
    }

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        SessionState.ExportObject exportObject;
        block8: {
            QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("resolveDescriptor:" + String.valueOf(descriptor));
            try {
                exportObject = this.getResolver(descriptor, logId).resolve(session, descriptor, logId);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    return SessionState.wrapAsFailedExport(e);
                }
            }
            ignored.close();
        }
        return exportObject;
    }

    public <T> SessionState.ExportBuilder<T> publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish) {
        String ticketName = this.getLogNameFor(ticket, logId);
        try (QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("publishTicket:" + ticketName);){
            TicketResolver resolver = this.getResolver(ticket.get(ticket.position()), logId);
            this.authorization.authorizePublishRequest(resolver, ticket);
            SessionState.ExportBuilder exportBuilder = resolver.publish(session, ticket, logId, onPublish);
            return exportBuilder;
        }
    }

    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.Ticket ticket, String logId, @Nullable Runnable onPublish) {
        return this.publish(session, ticket.getTicket().asReadOnlyByteBuffer(), logId, onPublish);
    }

    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Ticket ticket, String logId, @Nullable Runnable onPublish) {
        return this.publish(session, ticket.getTicket().asReadOnlyByteBuffer(), logId, onPublish);
    }

    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.FlightDescriptor descriptor, String logId, @Nullable Runnable onPublish) {
        try (QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("publishDescriptor:" + String.valueOf(descriptor));){
            TicketResolver resolver = this.getResolver(descriptor, logId);
            this.authorization.authorizePublishRequest(resolver, descriptor);
            SessionState.ExportBuilder exportBuilder = resolver.publish(session, descriptor, logId, onPublish);
            return exportBuilder;
        }
    }

    public <T> void publish(SessionState session, Ticket ticket, String logId, @Nullable Runnable onPublish, SessionState.ExportErrorHandler errorHandler, SessionState.ExportObject<T> source) {
        String ticketName = this.getLogNameFor(ticket, logId);
        try (QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("publishTicket:" + ticketName);){
            ByteBuffer ticketBuffer = ticket.getTicket().asReadOnlyByteBuffer();
            TicketResolver resolver = this.getResolver(ticketBuffer.get(ticketBuffer.position()), logId);
            this.authorization.authorizePublishRequest(resolver, ticketBuffer);
            resolver.publish(session, ticketBuffer, logId, onPublish, errorHandler, source);
        }
    }

    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        SessionState.ExportObject<Flight.FlightInfo> exportObject;
        block8: {
            QueryPerformanceNugget ignored = QueryPerformanceRecorder.getInstance().getNugget("flightInfoForDescriptor:" + String.valueOf(descriptor));
            try {
                exportObject = this.getResolver(descriptor, logId).flightInfoFor(session, descriptor, logId);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            ignored.close();
        }
        return exportObject;
    }

    public String getLogNameFor(Ticket ticket, String logId) {
        return this.getLogNameFor(ticket.getTicket().asReadOnlyByteBuffer(), logId);
    }

    public String getLogNameFor(Flight.Ticket ticket, String logId) {
        return this.getLogNameFor(ticket.getTicket().asReadOnlyByteBuffer(), logId);
    }

    public String getLogNameFor(ByteBuffer ticket, String logId) {
        return this.getResolver(ticket.get(ticket.position()), logId).getLogNameFor(ticket, logId);
    }

    public void visitFlightInfo(@Nullable SessionState session, Consumer<Flight.FlightInfo> visitor) {
        QueryPerformanceRecorder qpr = QueryPerformanceRecorder.getInstance();
        try (QueryPerformanceNugget ignored = qpr.getNugget("visitFlightInfo");){
            this.enabledResolvers.forEach(resolver -> resolver.forAllFlightInfo(session, visitor));
        }
    }

    public static Flight.FlightInfo getFlightInfo(Table table, Flight.FlightDescriptor descriptor, Flight.Ticket ticket) {
        return Flight.FlightInfo.newBuilder().setSchema(BarrageUtil.schemaBytesFromTable((Table)table)).setFlightDescriptor(descriptor).addEndpoint(Flight.FlightEndpoint.newBuilder().setTicket(ticket).build()).setTotalRecords(table.isRefreshing() ? -1L : table.size()).setTotalBytes(-1L).build();
    }

    private TicketResolver getResolver(byte route, String logId) {
        TicketResolver resolver = (TicketResolver)this.byteResolverMap.get((int)route);
        if (resolver == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': no resolver for route '" + route + "' (byte)"));
        }
        return resolver;
    }

    private TicketResolver getResolver(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor.getType() == Flight.FlightDescriptor.DescriptorType.PATH) {
            return this.getPathResolver(descriptor, logId);
        }
        if (descriptor.getType() == Flight.FlightDescriptor.DescriptorType.CMD) {
            return this.getCommandResolver(descriptor, logId);
        }
        throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': unexpected type"));
    }

    private PathResolver getPathResolver(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw new IllegalStateException("descriptor is not a path");
        }
        if (descriptor.getPathCount() <= 0) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': flight descriptor does not have route path"));
        }
        String route = descriptor.getPath(0);
        PathResolverPrefixedBase prefixedResolver = (PathResolverPrefixedBase)this.prefixedPathResolverMap.get((Object)route);
        PathResolver genericResolver = this.getGenericPathResolver(descriptor, logId, route).orElse(null);
        if (prefixedResolver == null && genericResolver == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': no resolver for path route '" + route + "'"));
        }
        if (prefixedResolver != null && genericResolver != null) {
            throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)("Could not resolve '" + logId + "': multiple resolvers for path route '" + route + "'"));
        }
        return prefixedResolver != null ? prefixedResolver : Objects.requireNonNull(genericResolver);
    }

    private Optional<PathResolver> getGenericPathResolver(Flight.FlightDescriptor descriptor, String logId, String route) {
        PathResolver genericResolver = null;
        for (PathResolver resolver : this.genericPathResolvers) {
            if (!resolver.handlesPath(descriptor)) continue;
            if (genericResolver != null) {
                throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)("Could not resolve '" + logId + "': multiple resolvers for path route '" + route + "'"));
            }
            genericResolver = resolver;
        }
        return Optional.ofNullable(genericResolver);
    }

    private CommandResolver getCommandResolver(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.CMD) {
            throw new IllegalStateException("descriptor is not a command");
        }
        CommandResolver commandResolver = null;
        for (CommandResolver resolver : this.commandResolvers) {
            if (!resolver.handlesCommand(descriptor)) continue;
            if (commandResolver != null) {
                throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)("Could not resolve '" + logId + "': multiple resolvers for command"));
            }
            commandResolver = resolver;
        }
        if (commandResolver == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve '" + logId + "': no resolver for command"));
        }
        return commandResolver;
    }
}

