/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import io.deephaven.server.session.SessionState;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.Nullable;

public interface TicketResolver {
    public byte ticketRoute();

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState var1, ByteBuffer var2, String var3);

    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState var1, Flight.FlightDescriptor var2, String var3);

    public <T> SessionState.ExportBuilder<T> publish(SessionState var1, ByteBuffer var2, String var3, @Nullable Runnable var4);

    public <T> SessionState.ExportBuilder<T> publish(SessionState var1, Flight.FlightDescriptor var2, String var3, @Nullable Runnable var4);

    default public <T> void publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish, SessionState.ExportErrorHandler errorHandler, SessionState.ExportObject<T> source) {
        this.publish(session, ticket, logId, onPublish).onError(errorHandler).require(source).submit(source::get);
    }

    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState var1, Flight.FlightDescriptor var2, String var3);

    public String getLogNameFor(ByteBuffer var1, String var2);

    public void forAllFlightInfo(@Nullable SessionState var1, Consumer<Flight.FlightInfo> var2);

    public static interface Authorization {
        default public boolean isDeniedAccess(Object source) {
            return this.transform(source) == null;
        }

        public <T> T transform(T var1);

        public void authorizePublishRequest(TicketResolver var1, ByteBuffer var2);

        public void authorizePublishRequest(TicketResolver var1, Flight.FlightDescriptor var2);
    }
}

