/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.google.common.collect.MapMaker;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.backplane.grpc.ExportNotification;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.flight.util.FlightExportTicketHelper;
import io.deephaven.proto.flight.util.TicketRouterHelper;
import io.deephaven.proto.util.ByteHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.SharedTicketHelper;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolverBase;
import io.deephaven.server.session.TicketRouter;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class SharedTicketResolver
extends TicketResolverBase {
    private final ConcurrentMap<ByteString, SessionState.ExportObject<?>> sharedVariables = new MapMaker().weakValues().makeMap();

    @Inject
    public SharedTicketResolver(AuthorizationProvider authProvider) {
        super(authProvider, (byte)104, "shared");
    }

    @Override
    public String getLogNameFor(ByteBuffer ticket, String logId) {
        ByteString ticketId = SharedTicketResolver.idForTicket(ticket, logId);
        return String.format("%s/%s", "shared", SharedTicketResolver.toHexString(ticketId));
    }

    @NotNull
    private static String toHexString(ByteString ticketId) {
        return ByteHelper.byteBufToHex((ByteBuffer)ticketId.asReadOnlyByteBuffer());
    }

    @Override
    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        if (session == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)String.format("Could not resolve '%s': no session to handoff to", logId));
        }
        ByteString sharedId = SharedTicketResolver.idForDescriptor(descriptor, logId);
        SessionState.ExportObject export = (SessionState.ExportObject)((Object)this.sharedVariables.get(sharedId));
        if (export == null) {
            throw SharedTicketResolver.newNotFoundSRE(logId, SharedTicketResolver.toHexString(sharedId));
        }
        return session.nonExport().require(export).submit(() -> {
            Object result = export.get();
            if (result instanceof Table) {
                result = this.authorization.transform(result);
            }
            if (result instanceof Table) {
                return TicketRouter.getFlightInfo((Table)result, descriptor, FlightExportTicketHelper.descriptorToFlightTicket((Flight.FlightDescriptor)descriptor, (String)logId));
            }
            throw SharedTicketResolver.newNotFoundSRE(logId, SharedTicketResolver.toHexString(sharedId));
        });
    }

    @Override
    public void forAllFlightInfo(@Nullable SessionState session, Consumer<Flight.FlightInfo> visitor) {
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteBuffer ticket, String logId) {
        return this.resolve(session, SharedTicketResolver.idForTicket(ticket, logId), logId);
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        return this.resolve(session, SharedTicketResolver.idForDescriptor(descriptor, logId), logId);
    }

    private <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteString sharedId, String logId) {
        if (session == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)String.format("Could not resolve '%s': no session to handoff to", logId));
        }
        SessionState.ExportObject sharedVar = (SessionState.ExportObject)((Object)this.sharedVariables.get(sharedId));
        if (sharedVar == null) {
            return SessionState.wrapAsFailedExport((Exception)SharedTicketResolver.newNotFoundSRE(logId, SharedTicketResolver.toHexString(sharedId)));
        }
        return session.nonExport().require(sharedVar).submit(() -> {
            Object result = sharedVar.get();
            if ((result = this.authorization.transform(result)) == null) {
                throw SharedTicketResolver.newNotFoundSRE(logId, SharedTicketResolver.toHexString(sharedId));
            }
            return result;
        });
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish) {
        return (SessionState.ExportBuilder)SharedTicketResolver.failDueToBadSource(logId, SharedTicketResolver.toHexString(SharedTicketResolver.idForTicket(ticket, logId)));
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.FlightDescriptor descriptor, String logId, @Nullable Runnable onPublish) {
        return (SessionState.ExportBuilder)SharedTicketResolver.failDueToBadSource(logId, SharedTicketResolver.toHexString(SharedTicketResolver.idForDescriptor(descriptor, logId)));
    }

    @Override
    public <T> void publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish, SessionState.ExportErrorHandler errorHandler, SessionState.ExportObject<T> source) {
        if (source.isNonExport()) {
            SharedTicketResolver.failDueToBadSource(logId, SharedTicketResolver.toHexString(SharedTicketResolver.idForTicket(ticket, logId)));
            return;
        }
        ByteString sharedId = SharedTicketResolver.idForTicket(ticket, logId);
        SessionState.ExportObject<T> existing = this.sharedVariables.putIfAbsent(sharedId, source);
        if (existing != null) {
            String ticketHex = SharedTicketResolver.toHexString(sharedId);
            errorHandler.onError(ExportNotification.State.FAILED, "", (Exception)Exceptions.statusRuntimeException((Code)Code.ALREADY_EXISTS, (String)String.format("Could not publish '%s' to shared ticket '%s' (hex): destination already exists", logId, ticketHex)), null);
        } else if (onPublish != null) {
            onPublish.run();
        }
    }

    private static <T> T failDueToBadSource(String logId, String ticketHex) {
        throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not publish '%s' to shared ticket '%s' (hex): can only publish directly from a session export to a shared ticket", logId, ticketHex));
    }

    public static Flight.Ticket flightTicketForId(byte[] identifier) {
        return Flight.Ticket.newBuilder().setTicket(ByteString.copyFrom((byte[])identifier)).build();
    }

    public static Ticket ticketForId(byte[] identifier) {
        return Ticket.newBuilder().setTicket(ByteString.copyFrom((byte[])identifier)).build();
    }

    public static Flight.FlightDescriptor descriptorForId(byte[] identifier) {
        return Flight.FlightDescriptor.newBuilder().setType(Flight.FlightDescriptor.DescriptorType.PATH).addAllPath((Iterable)SharedTicketHelper.idToPath((byte[])identifier)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteString idForTicket(ByteBuffer ticket, String logId) {
        if (ticket == null || ticket.remaining() == 0) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not resolve '%s': no ticket supplied", logId));
        }
        if (ticket.remaining() < 2 || ticket.get(ticket.position()) != 104) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not resolve '%s': found 0x%s (hex)", logId, ByteHelper.byteBufToHex((ByteBuffer)ticket)));
        }
        int initialPosition = ticket.position();
        try {
            ticket.position(initialPosition + 1);
            byte[] dst = new byte[ticket.remaining()];
            ticket.get(dst);
            ByteString byteString = ByteStringAccess.wrap((byte[])dst);
            return byteString;
        }
        finally {
            ticket.position(initialPosition);
        }
    }

    private static ByteString idForDescriptor(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not resolve descriptor '%s': only paths are supported", logId));
        }
        if (descriptor.getPathCount() != 2) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not resolve descriptor '%s': unexpected path length (found: %s, expected: 2)", logId, TicketRouterHelper.getLogNameFor((Flight.FlightDescriptor)descriptor)));
        }
        if (!descriptor.getPath(0).equals("shared")) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)String.format("Could not resolve descriptor '%s': unexpected path (found: %s, expected: %s)", logId, TicketRouterHelper.getLogNameFor((Flight.FlightDescriptor)descriptor), "shared"));
        }
        return ByteString.fromHex((String)descriptor.getPath(1));
    }

    public static Flight.FlightDescriptor ticketToDescriptor(Flight.Ticket ticket, String logId) {
        return SharedTicketResolver.descriptorForId(SharedTicketResolver.idForTicket(ticket.getTicket().asReadOnlyByteBuffer(), logId).toByteArray());
    }

    public static Flight.Ticket descriptorToTicket(Flight.FlightDescriptor descriptor, String logId) {
        return SharedTicketResolver.flightTicketForId(SharedTicketResolver.idForDescriptor(descriptor, logId).toByteArray());
    }

    @NotNull
    private static StatusRuntimeException newNotFoundSRE(String logId, String sharedId) {
        return Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)String.format("Could not resolve '%s': ticket '%s' not found", logId, sharedId));
    }
}

