/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.github.f4b6a3.uuid.UuidCreator;
import com.google.rpc.Code;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import io.deephaven.auth.AuthContext;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.reference.WeakSimpleReference;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessArtifact;
import io.deephaven.engine.liveness.LivenessReferent;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.perf.QueryState;
import io.deephaven.engine.table.impl.util.EngineMetrics;
import io.deephaven.engine.updategraph.DynamicNode;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.hash.KeyedIntObjectHash;
import io.deephaven.hash.KeyedIntObjectHashMap;
import io.deephaven.hash.KeyedIntObjectKey;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.log.LogEntry;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.ExportNotification;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.flight.util.FlightExportTicketHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.util.Scheduler;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.SimpleReferenceManager;
import io.deephaven.util.process.ProcessEnvironment;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.inject.Provider;
import org.apache.arrow.flight.impl.Flight;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class SessionState {
    public static final int NON_EXPORT_ID = 0;
    private static final Logger log = LoggerFactory.getLogger(SessionState.class);
    private final String logPrefix;
    private final Scheduler scheduler;
    private final SessionService.ErrorTransformer errorTransformer;
    private final AuthContext authContext;
    private final String sessionId;
    private volatile SessionService.TokenExpiration expiration = null;
    private static final AtomicReferenceFieldUpdater<SessionState, SessionService.TokenExpiration> EXPIRATION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SessionState.class, SessionService.TokenExpiration.class, "expiration");
    private volatile int nextServerAllocatedId = -1;
    private static final AtomicIntegerFieldUpdater<SessionState> SERVER_EXPORT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SessionState.class, "nextServerAllocatedId");
    private final KeyedIntObjectHashMap<ExportObject<?>> exportMap = new KeyedIntObjectHashMap(EXPORT_OBJECT_ID_KEY);
    private final List<ExportListener> exportListeners = new CopyOnWriteArrayList<ExportListener>();
    private volatile int exportListenerVersion = 0;
    private final SimpleReferenceManager<Closeable, WeakSimpleReference<Closeable>> onCloseCallbacks = new SimpleReferenceManager(WeakSimpleReference::new, false);
    private final ExecutionContext executionContext;
    private static final KeyedIntObjectKey<ExportObject<?>> EXPORT_OBJECT_ID_KEY = new KeyedIntObjectKey.BasicStrict<ExportObject<?>>(){

        public int getIntKey(ExportObject<?> exportObject) {
            return exportObject.exportId;
        }
    };
    private final KeyedIntObjectHash.ValueFactory<ExportObject<?>> EXPORT_OBJECT_VALUE_FACTORY = new KeyedIntObjectHash.ValueFactory.Strict<ExportObject<?>>(){

        public ExportObject<?> newValue(int key) {
            if (SessionState.this.isExpired()) {
                throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
            }
            return new ExportObject(SessionState.this.errorTransformer, SessionState.this, key);
        }
    };

    public static <T> ExportObject<T> wrapAsExport(T export) {
        return new ExportObject<T>(export, null);
    }

    public static <T> ExportObject<T> wrapAsFailedExport(Exception caughtException) {
        ExportObject<Object> exportObject = new ExportObject<Object>(null, caughtException);
        return exportObject;
    }

    @AssistedInject
    public SessionState(Scheduler scheduler, SessionService.ErrorTransformer errorTransformer, Provider<ExecutionContext> executionContextProvider, @Assisted AuthContext authContext) {
        this.sessionId = UuidCreator.toString((UUID)UuidCreator.getRandomBased());
        this.logPrefix = "SessionState{" + this.sessionId + "}: ";
        this.scheduler = scheduler;
        this.errorTransformer = errorTransformer;
        this.authContext = authContext;
        this.executionContext = ((ExecutionContext)executionContextProvider.get()).withAuthContext(authContext);
        log.debug().append((CharSequence)this.logPrefix).append((CharSequence)"session initialized").endl();
    }

    @VisibleForTesting
    protected void initializeExpiration(@NotNull SessionService.TokenExpiration expiration) {
        if (expiration.session != this) {
            throw new IllegalArgumentException("mismatched session for expiration token");
        }
        if (!EXPIRATION_UPDATER.compareAndSet(this, null, expiration)) {
            throw new IllegalStateException("session already initialized");
        }
        log.debug().append((CharSequence)this.logPrefix).append((CharSequence)"token initialized to '").append((CharSequence)expiration.token.toString()).append((CharSequence)"' which expires at ").append(LogOutput.MILLIS_FROM_EPOCH_FORMATTER, expiration.deadlineMillis).append((CharSequence)".").endl();
    }

    @VisibleForTesting
    protected void updateExpiration(@NotNull SessionService.TokenExpiration expiration) {
        if (expiration.session != this) {
            throw new IllegalArgumentException("mismatched session for expiration token");
        }
        SessionService.TokenExpiration prevToken = this.expiration;
        while (prevToken != null && !EXPIRATION_UPDATER.compareAndSet(this, prevToken, expiration)) {
            prevToken = this.expiration;
        }
        if (prevToken == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        log.debug().append((CharSequence)this.logPrefix).append((CharSequence)"token, expires at ").append(LogOutput.MILLIS_FROM_EPOCH_FORMATTER, expiration.deadlineMillis).append((CharSequence)".").endl();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionService.TokenExpiration getExpiration() {
        if (this.isExpired()) {
            return null;
        }
        return this.expiration;
    }

    public boolean isExpired() {
        SessionService.TokenExpiration currToken = this.expiration;
        return currToken == null || currToken.deadlineMillis <= this.scheduler.currentTimeMillis();
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public <T> ExportObject<T> getExport(Ticket ticket, String logId) {
        return this.getExport(ExportTicketHelper.ticketToExportId((Ticket)ticket, (String)logId));
    }

    public <T> ExportObject<T> getExport(Flight.Ticket ticket, String logId) {
        return this.getExport(FlightExportTicketHelper.ticketToExportId((Flight.Ticket)ticket, (String)logId));
    }

    public <T> ExportObject<T> getExport(int exportId) {
        ExportObject result;
        if (this.isExpired()) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        if (exportId < 0) {
            result = (ExportObject)((Object)this.exportMap.get(exportId));
            if (result == null) {
                throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Export id " + exportId + " does not exist and cannot be used out-of-order!"));
            }
        } else if (exportId > 0) {
            result = (ExportObject)((Object)this.exportMap.putIfAbsent(exportId, this.EXPORT_OBJECT_VALUE_FACTORY));
        } else {
            throw Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)("Export id " + exportId + " refers to a non-export and cannot be requested!"));
        }
        return result;
    }

    public <T> ExportObject<T> getExportIfExists(int exportId) {
        if (this.isExpired()) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        return (ExportObject)((Object)this.exportMap.get(exportId));
    }

    public <T> ExportObject<T> getExportIfExists(Ticket ticket, String logId) {
        return this.getExportIfExists(ExportTicketHelper.ticketToExportId((Ticket)ticket, (String)logId));
    }

    public <T> ExportObject<T> newServerSideExport(T export) {
        if (this.isExpired()) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        int exportId = SERVER_EXPORT_UPDATER.getAndDecrement(this);
        ExportObject result = (ExportObject)((Object)this.exportMap.putIfAbsent(exportId, this.EXPORT_OBJECT_VALUE_FACTORY));
        result.setResult(export);
        return result;
    }

    public <T> ExportBuilder<T> newExport(Flight.Ticket ticket, String logId) {
        return this.newExport(FlightExportTicketHelper.ticketToExportId((Flight.Ticket)ticket, (String)logId));
    }

    public <T> ExportBuilder<T> newExport(Ticket ticket, String logId) {
        return this.newExport(ExportTicketHelper.ticketToExportId((Ticket)ticket, (String)logId));
    }

    @VisibleForTesting
    public <T> ExportBuilder<T> newExport(int exportId) {
        if (this.isExpired()) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        if (exportId <= 0) {
            throw new IllegalArgumentException("exportId's <= 0 are reserved for server allocation only");
        }
        return new ExportBuilder(exportId);
    }

    public <T> ExportBuilder<T> nonExport() {
        if (this.isExpired()) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
        }
        return new ExportBuilder(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCloseCallback(Closeable onClose) {
        SimpleReferenceManager<Closeable, WeakSimpleReference<Closeable>> simpleReferenceManager = this.onCloseCallbacks;
        synchronized (simpleReferenceManager) {
            if (this.isExpired()) {
                throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
            }
            this.onCloseCallbacks.add((Object)onClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOnCloseCallback(Closeable onClose) {
        if (this.isExpired()) {
            return false;
        }
        SimpleReferenceManager<Closeable, WeakSimpleReference<Closeable>> simpleReferenceManager = this.onCloseCallbacks;
        synchronized (simpleReferenceManager) {
            return this.onCloseCallbacks.remove((Object)onClose) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExpired() {
        ArrayList callbacksToClose;
        SessionService.TokenExpiration prevToken = this.expiration;
        while (prevToken != null && !EXPIRATION_UPDATER.compareAndSet(this, prevToken, null)) {
            prevToken = this.expiration;
        }
        if (prevToken == null) {
            return;
        }
        log.debug().append((CharSequence)this.logPrefix).append((CharSequence)"releasing outstanding exports").endl();
        Object object = this.exportMap;
        synchronized (object) {
            this.exportMap.forEach(ExportObject::cancel);
            this.exportMap.clear();
        }
        log.debug().append((CharSequence)this.logPrefix).append((CharSequence)"outstanding exports released").endl();
        object = this.exportListeners;
        synchronized (object) {
            this.exportListeners.forEach(ExportListener::onRemove);
            this.exportListeners.clear();
        }
        SimpleReferenceManager<Closeable, WeakSimpleReference<Closeable>> simpleReferenceManager = this.onCloseCallbacks;
        synchronized (simpleReferenceManager) {
            callbacksToClose = new ArrayList(this.onCloseCallbacks.size());
            this.onCloseCallbacks.forEach((ref, callback) -> callbacksToClose.add(callback));
            this.onCloseCallbacks.clear();
        }
        callbacksToClose.forEach(callback -> {
            try {
                callback.close();
            }
            catch (IOException e) {
                log.error().append((CharSequence)this.logPrefix).append((CharSequence)"error during onClose callback: ").append((Throwable)e).endl();
            }
        });
    }

    public static boolean isExportStateFailure(ExportNotification.State state) {
        return state == ExportNotification.State.FAILED || state == ExportNotification.State.CANCELLED || state == ExportNotification.State.DEPENDENCY_FAILED || state == ExportNotification.State.DEPENDENCY_NEVER_FOUND || state == ExportNotification.State.DEPENDENCY_RELEASED || state == ExportNotification.State.DEPENDENCY_CANCELLED;
    }

    public static boolean isExportStateTerminal(ExportNotification.State state) {
        return state == ExportNotification.State.RELEASED || SessionState.isExportStateFailure(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportListener(StreamObserver<ExportNotification> observer) {
        int versionId;
        ExportListener listener;
        List<ExportListener> list = this.exportListeners;
        synchronized (list) {
            if (this.isExpired()) {
                throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
            }
            listener = new ExportListener(observer);
            this.exportListeners.add(listener);
            versionId = ++this.exportListenerVersion;
        }
        listener.initialize(versionId);
    }

    public StreamObserver<ExportNotification> removeExportListener(StreamObserver<ExportNotification> observer) {
        MutableObject wrappedListener = new MutableObject();
        boolean found = this.exportListeners.removeIf(wrap -> {
            boolean matches;
            if (wrappedListener.getValue() != null) {
                return false;
            }
            boolean bl = matches = wrap.listener == observer;
            if (matches) {
                wrappedListener.setValue(wrap);
            }
            return matches;
        });
        if (found) {
            ((ExportListener)wrappedListener.getValue()).onRemove();
        }
        return found ? observer : null;
    }

    @VisibleForTesting
    public long numExportListeners() {
        return this.exportListeners.size();
    }

    public static ExportErrorHandler toErrorHandler(ExportErrorGrpcHandler errorHandler) {
        return (resultState, errorContext, cause, dependentExportId) -> {
            Object dependentStr;
            if (cause instanceof StatusRuntimeException) {
                errorHandler.onError((StatusRuntimeException)cause);
                return;
            }
            Object object = dependentStr = dependentExportId == null ? "" : " (related parent export id: " + dependentExportId + ")";
            if (cause == null) {
                if (resultState == ExportNotification.State.CANCELLED) {
                    errorHandler.onError(Exceptions.statusRuntimeException((Code)Code.CANCELLED, (String)("Export is cancelled" + (String)dependentStr)));
                } else {
                    errorHandler.onError(Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Export in state " + String.valueOf(resultState) + (String)dependentStr)));
                }
            } else {
                errorHandler.onError(Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Details Logged w/ID '" + errorContext + "'" + (String)dependentStr)));
            }
        };
    }

    public static final class ExportObject<T>
    extends LivenessArtifact {
        private final int exportId;
        private final String logIdentity;
        private final SessionService.ErrorTransformer errorTransformer;
        private final SessionState session;
        private QueryPerformanceRecorder queryPerformanceRecorder;
        private volatile T result;
        private volatile ExportNotification.State state = ExportNotification.State.UNKNOWN;
        private volatile int exportListenerVersion = 0;
        private boolean hasHadWorkSet = false;
        private boolean requiresSerialQueue;
        private Callable<T> exportMain;
        @Nullable
        private ExportErrorHandler errorHandler;
        @Nullable
        private Consumer<? super T> successHandler;
        private List<ExportObject<?>> children = Collections.emptyList();
        private List<ExportObject<?>> parents = Collections.emptyList();
        private volatile int dependentCount = -1;
        private ExportObject<?> alreadyDeadParent;
        private static final AtomicIntegerFieldUpdater<ExportObject<?>> DEPENDENT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExportObject.class, "dependentCount");
        private String errorId;
        private String failedDependencyLogIdentity;
        private Exception caughtException;

        private ExportObject(SessionService.ErrorTransformer errorTransformer, SessionState session, int exportId) {
            super(true);
            this.errorTransformer = errorTransformer;
            this.session = session;
            this.exportId = exportId;
            this.logIdentity = this.isNonExport() ? Integer.toHexString(System.identityHashCode((Object)this)) : Long.toString(exportId);
            this.setState(ExportNotification.State.UNKNOWN);
            this.retainReference();
        }

        private ExportObject(T result, Exception caughtException) {
            super(true);
            this.errorTransformer = null;
            this.session = null;
            this.exportId = 0;
            this.result = result;
            this.dependentCount = 0;
            this.hasHadWorkSet = true;
            this.logIdentity = Integer.toHexString(System.identityHashCode((Object)this)) + "-sessionless";
            if (result == null) {
                this.maybeAssignErrorId(caughtException, null);
                this.state = ExportNotification.State.FAILED;
            } else {
                this.state = ExportNotification.State.EXPORTED;
            }
            if (result instanceof LivenessReferent && DynamicNode.notDynamicOrIsRefreshing(result)) {
                this.manage((LivenessReferent)result);
            }
        }

        public boolean isNonExport() {
            return this.exportId == 0;
        }

        private synchronized void setQueryPerformanceRecorder(QueryPerformanceRecorder queryPerformanceRecorder) {
            if (this.queryPerformanceRecorder != null) {
                throw new IllegalStateException("performance query recorder can only be set once on an exportable object");
            }
            this.queryPerformanceRecorder = queryPerformanceRecorder;
        }

        private synchronized void setDependencies(List<ExportObject<?>> parents) {
            if (this.dependentCount != -1) {
                throw new IllegalStateException("dependencies can only be set once on an exportable object");
            }
            this.parents = parents;
            this.dependentCount = parents.size();
            for (ExportObject<?> parent : parents) {
                if (parent == null || this.tryManage((LivenessReferent)parent)) continue;
                this.forceReferenceCountToZero();
                this.alreadyDeadParent = parent;
                break;
            }
            if (log.isDebugEnabled()) {
                RuntimeException e = new RuntimeException();
                LogEntry entry = log.debug().append((Throwable)e).nl().append((CharSequence)this.session.logPrefix).append((CharSequence)"export '").append((CharSequence)this.logIdentity).append((CharSequence)"' has ").append(this.dependentCount).append((CharSequence)" dependencies remaining: ");
                for (ExportObject<?> parent : parents) {
                    entry.nl().append('\t').append((CharSequence)parent.logIdentity).append((CharSequence)" is ").append((CharSequence)parent.getState().name());
                }
                entry.endl();
            }
        }

        private synchronized void setWork(@NotNull Callable<T> exportMain, @Nullable ExportErrorHandler errorHandler, @Nullable Consumer<? super T> successHandler, boolean requiresSerialQueue) {
            if (this.hasHadWorkSet) {
                throw new IllegalStateException("export object can only be defined once");
            }
            this.hasHadWorkSet = true;
            if (this.queryPerformanceRecorder != null && this.queryPerformanceRecorder.getState() == QueryState.RUNNING) {
                this.queryPerformanceRecorder.suspendQuery();
            }
            this.requiresSerialQueue = requiresSerialQueue;
            if (this.alreadyDeadParent != null) {
                this.onDependencyFailure(this.alreadyDeadParent);
                this.alreadyDeadParent = null;
            }
            if (SessionState.isExportStateTerminal(this.state)) {
                if (errorHandler != null) {
                    this.maybeAssignErrorId(this.caughtException, null);
                    errorHandler.onError(this.state, this.errorId, this.caughtException, this.failedDependencyLogIdentity);
                }
                return;
            }
            this.exportMain = Objects.requireNonNull(exportMain);
            this.errorHandler = errorHandler;
            this.successHandler = successHandler;
            if (this.state != ExportNotification.State.PUBLISHING) {
                this.setState(ExportNotification.State.PENDING);
            } else if (this.dependentCount > 0) {
                throw new IllegalStateException("published exports cannot have dependencies");
            }
            if (this.dependentCount <= 0) {
                this.dependentCount = 0;
                this.scheduleExport();
            } else {
                for (ExportObject<?> parent : this.parents) {
                    if (parent != null && parent.maybeAddDependency(this)) continue;
                    this.onResolveOne(parent);
                }
            }
        }

        public T get() {
            if (this.session != null && this.session.isExpired()) {
                throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)"session has expired");
            }
            T localResult = this.result;
            if (localResult == null) {
                throw new IllegalStateException("Dependent export '" + this.exportId + "' is null and in state " + this.state.name());
            }
            return localResult;
        }

        public ExportNotification.State getState() {
            return this.state;
        }

        public Ticket getExportId() {
            return ExportTicketHelper.wrapExportIdInTicket((int)this.exportId);
        }

        public int getExportIdInt() {
            return this.exportId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeAddDependency(ExportObject<?> child) {
            if (this.state == ExportNotification.State.EXPORTED || SessionState.isExportStateTerminal(this.state)) {
                return false;
            }
            ExportObject exportObject = this;
            synchronized (exportObject) {
                if (this.state == ExportNotification.State.EXPORTED || SessionState.isExportStateTerminal(this.state)) {
                    return false;
                }
                if (this.children.isEmpty()) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
                return true;
            }
        }

        private synchronized void setState(ExportNotification.State state) {
            boolean isNowExported;
            if (this.state == ExportNotification.State.EXPORTED && this.isNonExport() || SessionState.isExportStateTerminal(this.state)) {
                throw new IllegalStateException("cannot change state if export is already in terminal state");
            }
            if (this.state != ExportNotification.State.UNKNOWN && this.state.getNumber() >= state.getNumber()) {
                throw new IllegalStateException("export object state changes must advance toward a terminal state");
            }
            this.state = state;
            if (this.exportId != 0) {
                log.debug().append((CharSequence)this.session.logPrefix).append((CharSequence)"export '").append((CharSequence)this.logIdentity).append((CharSequence)"' is ExportState.").append((CharSequence)state.name()).endl();
                ExportNotification notification = this.makeExportNotification();
                this.exportListenerVersion = this.session.exportListenerVersion;
                this.session.exportListeners.forEach(listener -> listener.notify(notification));
            } else {
                log.debug().append((CharSequence)(this.session == null ? "Session " : this.session.logPrefix)).append((CharSequence)"non-export '").append((CharSequence)this.logIdentity).append((CharSequence)"' is ExportState.").append((CharSequence)state.name()).endl();
            }
            if (SessionState.isExportStateFailure(state) && this.errorHandler != null) {
                this.maybeAssignErrorId(this.caughtException, null);
                try {
                    Exception toReport = this.caughtException != null && this.errorTransformer != null ? this.errorTransformer.transform(this.caughtException) : this.caughtException;
                    this.errorHandler.onError(state, this.errorId, toReport, this.failedDependencyLogIdentity);
                }
                catch (Throwable err) {
                    log.error().append((CharSequence)"Unexpected error while reporting ExportObject failure: ").append(err).endl();
                    ProcessEnvironment.getGlobalFatalErrorReporter().reportAsync("Unexpected error while reporting ExportObject failure", err);
                }
            }
            boolean bl = isNowExported = state == ExportNotification.State.EXPORTED;
            if (isNowExported && this.successHandler != null) {
                try {
                    this.successHandler.accept(this.result);
                }
                catch (Throwable err) {
                    log.error().append((CharSequence)"Unexpected error while reporting ExportObject success: ").append(err).endl();
                    ProcessEnvironment.getGlobalFatalErrorReporter().reportAsync("Unexpected error while reporting ExportObject success", err);
                }
            }
            if (isNowExported || SessionState.isExportStateTerminal(state)) {
                this.children.forEach(child -> child.onResolveOne(this));
                this.children = Collections.emptyList();
                this.parents.stream().filter(Objects::nonNull).forEach(arg_0 -> ((ExportObject)this).tryUnmanage(arg_0));
                this.parents = Collections.emptyList();
                this.exportMain = null;
                this.errorHandler = null;
                this.successHandler = null;
            }
            if (isNowExported && this.isNonExport() || SessionState.isExportStateTerminal(state)) {
                this.dropReference();
            }
        }

        private void onResolveOne(@Nullable ExportObject<?> parent) {
            if (SessionState.isExportStateTerminal(this.state)) {
                return;
            }
            if (parent != null && SessionState.isExportStateFailure(parent.state)) {
                this.onDependencyFailure(parent);
                return;
            }
            int newDepCount = DEPENDENT_COUNT_UPDATER.decrementAndGet(this);
            if (newDepCount > 0) {
                return;
            }
            Assert.eqZero((int)newDepCount, (String)"newDepCount");
            this.scheduleExport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleExport() {
            ExportObject exportObject = this;
            synchronized (exportObject) {
                if (this.state != ExportNotification.State.PENDING && this.state != ExportNotification.State.PUBLISHING) {
                    return;
                }
                this.setState(ExportNotification.State.QUEUED);
            }
            if (this.requiresSerialQueue) {
                this.session.scheduler.runSerially(this::doExport);
            } else {
                this.session.scheduler.runImmediately(this::doExport);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doExport() {
            Callable<T> capturedExport;
            ExportObject exportObject = this;
            synchronized (exportObject) {
                capturedExport = this.exportMain;
                if (this.state != ExportNotification.State.QUEUED || this.session.isExpired() || capturedExport == null || !this.tryRetainReference()) {
                    if (!SessionState.isExportStateTerminal(this.state)) {
                        this.setState(ExportNotification.State.CANCELLED);
                    } else if (this.errorHandler != null) {
                        Assert.statementNeverExecuted((String)"in terminal state but error handler is not null");
                    }
                    return;
                }
                this.dropReference();
                this.setState(ExportNotification.State.RUNNING);
            }
            T localResult = null;
            boolean shouldLog = false;
            try (SafeCloseable ignored1 = this.session.executionContext.open();
                 SafeCloseable ignored2 = LivenessScopeStack.open();){
                QueryPerformanceRecorder exportRecorder;
                block36: {
                    String queryId = this.isNonExport() ? "nonExport=" + this.logIdentity : "exportId=" + this.logIdentity;
                    boolean isResume = this.queryPerformanceRecorder != null && this.queryPerformanceRecorder.getState() == QueryState.SUSPENDED;
                    exportRecorder = Objects.requireNonNullElseGet(this.queryPerformanceRecorder, () -> QueryPerformanceRecorder.newQuery((String)("ExportObject#doWork(" + queryId + ")"), (String)this.session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY));
                    try (SafeCloseable ignored3 = isResume ? exportRecorder.resumeQuery() : exportRecorder.startQuery();){
                        try {
                            localResult = capturedExport.call();
                        }
                        catch (Exception err) {
                            this.caughtException = err;
                        }
                        shouldLog = exportRecorder.endQuery();
                    }
                    catch (Exception err) {
                        if (this.caughtException != null) break block36;
                        this.caughtException = err;
                    }
                }
                if (this.caughtException != null) {
                    ExportObject exportObject2 = this;
                    synchronized (exportObject2) {
                        if (!SessionState.isExportStateTerminal(this.state)) {
                            this.maybeAssignErrorId(this.caughtException, null);
                            this.setState(ExportNotification.State.FAILED);
                        }
                    }
                }
                if (shouldLog || this.caughtException != null) {
                    EngineMetrics.getInstance().logQueryProcessingResults(exportRecorder, this.caughtException);
                }
                if (this.caughtException == null) {
                    this.setResult(localResult);
                }
            }
        }

        private void maybeAssignErrorId(Exception caughtException, String errorDetails) {
            if (this.errorId == null) {
                this.errorId = UuidCreator.toString((UUID)UuidCreator.getRandomBased());
                if (caughtException == null && errorDetails == null) {
                    log.error().append((CharSequence)"Internal Error '").append((CharSequence)this.errorId).append((CharSequence)"' for ").append((CharSequence)this.logIdentity).append((CharSequence)" and no error details are available.").endl();
                    return;
                }
                this.caughtException = caughtException;
                if (!(caughtException instanceof StatusRuntimeException)) {
                    if (errorDetails != null) {
                        log.error().append((CharSequence)"Internal Error '").append((CharSequence)this.errorId).append((CharSequence)"' ").append((CharSequence)errorDetails).endl();
                    } else {
                        log.error().append((CharSequence)"Internal Error '").append((CharSequence)this.errorId).append((CharSequence)"' ").append((Throwable)caughtException).endl();
                    }
                } else if (errorDetails != null) {
                    log.info().append((CharSequence)"Export failed with Status Runtime Exception '").append((CharSequence)this.errorId).append((CharSequence)"' ").append((CharSequence)errorDetails).endl();
                } else {
                    log.info().append((CharSequence)"Export failed with Status Runtime Exception '").append((CharSequence)this.errorId).append((CharSequence)"' ").append((Throwable)caughtException).endl();
                }
            }
        }

        private synchronized void onDependencyFailure(ExportObject<?> parent) {
            this.errorId = parent.errorId;
            if (parent.caughtException instanceof StatusRuntimeException) {
                this.caughtException = parent.caughtException;
            }
            ExportNotification.State terminalState = ExportNotification.State.DEPENDENCY_FAILED;
            if (this.errorId == null) {
                Object errorDetails;
                switch (parent.state) {
                    case RELEASED: {
                        terminalState = ExportNotification.State.DEPENDENCY_RELEASED;
                        errorDetails = "dependency released by user.";
                        break;
                    }
                    case CANCELLED: {
                        terminalState = ExportNotification.State.DEPENDENCY_CANCELLED;
                        errorDetails = "dependency cancelled by user.";
                        break;
                    }
                    default: {
                        errorDetails = "dependency does not have its own error defined and is in an unexpected state: " + String.valueOf(parent.state);
                    }
                }
                this.maybeAssignErrorId(this.caughtException, (String)errorDetails);
                this.failedDependencyLogIdentity = parent.logIdentity;
            }
            this.setState(terminalState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setResult(T result) {
            if (this.result != null) {
                throw new IllegalStateException("cannot setResult twice!");
            }
            if (!this.tryRetainReference()) {
                return;
            }
            try {
                ExportObject exportObject = this;
                synchronized (exportObject) {
                    if (!SessionState.isExportStateTerminal(this.state)) {
                        this.result = result;
                        if (result instanceof LivenessReferent && DynamicNode.notDynamicOrIsRefreshing(result)) {
                            this.manage((LivenessReferent)result);
                        }
                        this.setState(ExportNotification.State.EXPORTED);
                    }
                }
            }
            finally {
                this.dropReference();
            }
        }

        public synchronized void release() {
            if (this.session == null) {
                throw new UnsupportedOperationException("Session-less exports cannot be released");
            }
            if (this.state == ExportNotification.State.EXPORTED) {
                if (this.isNonExport()) {
                    return;
                }
                this.setState(ExportNotification.State.RELEASED);
            } else if (!SessionState.isExportStateTerminal(this.state)) {
                this.session.nonExport().require(this).submit(this::release);
            }
        }

        public synchronized void cancel() {
            if (this.session == null) {
                throw new UnsupportedOperationException("Session-less exports cannot be cancelled");
            }
            if (this.state == ExportNotification.State.EXPORTED) {
                if (this.isNonExport()) {
                    return;
                }
                this.setState(ExportNotification.State.RELEASED);
            } else if (!SessionState.isExportStateTerminal(this.state)) {
                this.setState(ExportNotification.State.CANCELLED);
            }
        }

        @OverridingMethodsMustInvokeSuper
        protected synchronized void destroy() {
            super.destroy();
            this.result = null;
            if (!(this.caughtException instanceof StatusRuntimeException)) {
                this.caughtException = null;
            }
            this.queryPerformanceRecorder = null;
        }

        private synchronized ExportNotification makeExportNotification() {
            ExportNotification.Builder builder = ExportNotification.newBuilder().setTicket(ExportTicketHelper.wrapExportIdInTicket((int)this.exportId)).setExportState(this.state);
            if (this.errorId != null) {
                builder.setContext(this.errorId);
            }
            if (this.failedDependencyLogIdentity != null) {
                builder.setDependentHandle(this.failedDependencyLogIdentity);
            }
            return builder.build();
        }
    }

    public class ExportBuilder<T> {
        private final int exportId;
        private final ExportObject<T> export;
        private boolean requiresSerialQueue;
        private ExportErrorHandler errorHandler;
        private Consumer<? super T> successHandler;

        ExportBuilder(int exportId) {
            this.exportId = exportId;
            this.export = exportId == 0 ? new ExportObject(SessionState.this.errorTransformer, SessionState.this, 0) : (ExportObject)((Object)SessionState.this.exportMap.putIfAbsent(exportId, SessionState.this.EXPORT_OBJECT_VALUE_FACTORY));
        }

        public ExportBuilder<T> queryPerformanceRecorder(@NotNull QueryPerformanceRecorder queryPerformanceRecorder) {
            this.export.setQueryPerformanceRecorder(queryPerformanceRecorder);
            return this;
        }

        public ExportBuilder<T> requiresSerialQueue() {
            this.requiresSerialQueue = true;
            return this;
        }

        public ExportBuilder<T> require(ExportObject<?> ... dependencies) {
            this.export.setDependencies(List.of(dependencies));
            return this;
        }

        public ExportBuilder<T> require(List<? extends ExportObject<?>> dependencies) {
            this.export.setDependencies(List.copyOf(dependencies));
            return this;
        }

        public ExportBuilder<T> onError(ExportErrorHandler errorHandler) {
            if (this.errorHandler != null) {
                throw new IllegalStateException("error handler already set");
            }
            if (this.export.hasHadWorkSet) {
                throw new IllegalStateException("error handler must be set before work is submitted");
            }
            this.errorHandler = errorHandler;
            return this;
        }

        public ExportBuilder<T> onErrorHandler(ExportErrorGrpcHandler errorHandler) {
            return this.onError(SessionState.toErrorHandler(errorHandler));
        }

        public ExportBuilder<T> onError(StreamObserver<?> streamObserver) {
            return this.onErrorHandler(statusRuntimeException -> GrpcUtil.safelyError((StreamObserver)streamObserver, (StatusRuntimeException)statusRuntimeException));
        }

        public ExportBuilder<T> onSuccess(Consumer<? super T> successHandler) {
            if (this.successHandler != null) {
                throw new IllegalStateException("success handler already set");
            }
            if (this.export.hasHadWorkSet) {
                throw new IllegalStateException("success handler must be set before work is submitted");
            }
            this.successHandler = successHandler;
            return this;
        }

        public ExportBuilder<T> onSuccess(Runnable successHandler) {
            return this.onSuccess((? super T ignored) -> successHandler.run());
        }

        public ExportBuilder<T> onSuccess(StreamObserver<?> streamObserver) {
            return this.onSuccess(() -> GrpcUtil.safelyComplete((StreamObserver)streamObserver));
        }

        public ExportObject<T> submit(Callable<T> exportMain) {
            this.export.setWork(exportMain, this.errorHandler, this.successHandler, this.requiresSerialQueue);
            return this.export;
        }

        public ExportObject<T> submit(Runnable exportMain) {
            return this.submit(() -> {
                exportMain.run();
                return null;
            });
        }

        public ExportObject<T> getExport() {
            return this.export;
        }

        public int getExportId() {
            return this.exportId;
        }
    }

    private class ExportListener {
        private volatile boolean isClosed = false;
        private final StreamObserver<ExportNotification> listener;

        private ExportListener(StreamObserver<ExportNotification> listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(ExportNotification notification) {
            if (this.isClosed) {
                return;
            }
            try (SafeCloseable ignored = LivenessScopeStack.open();){
                StreamObserver<ExportNotification> streamObserver = this.listener;
                synchronized (streamObserver) {
                    this.listener.onNext((Object)notification);
                }
            }
            catch (RuntimeException e) {
                log.error().append((CharSequence)"Failed to notify listener: ").append((Throwable)e).endl();
                SessionState.this.removeExportListener(this.listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void initialize(int versionId) {
            String id = Integer.toHexString(System.identityHashCode(this));
            log.debug().append((CharSequence)SessionState.this.logPrefix).append((CharSequence)"refreshing listener ").append((CharSequence)id).endl();
            Iterator iterator = SessionState.this.exportMap.iterator();
            while (true) {
                ExportObject export;
                block13: {
                    block12: {
                        if (!iterator.hasNext()) {
                            this.notify(ExportNotification.newBuilder().setTicket(ExportTicketHelper.wrapExportIdInTicket((int)0)).setExportState(ExportNotification.State.EXPORTED).setContext("run is complete").build());
                            log.debug().append((CharSequence)SessionState.this.logPrefix).append((CharSequence)"run complete for listener ").append((CharSequence)id).endl();
                            return;
                        }
                        export = (ExportObject)((Object)iterator.next());
                        if (!export.tryRetainReference()) continue;
                        if (export.exportListenerVersion < versionId) break block12;
                        export.dropReference();
                        continue;
                    }
                    ExportObject exportObject = export;
                    // MONITORENTER : exportObject
                    if (export.exportListenerVersion < versionId) break block13;
                    // MONITOREXIT : exportObject
                    export.dropReference();
                    continue;
                }
                if (SessionState.isExportStateTerminal(export.getState())) {
                    // MONITOREXIT : exportObject
                    export.dropReference();
                    continue;
                }
                try {
                    this.notify(export.makeExportNotification());
                    // MONITOREXIT : exportObject
                    continue;
                }
                finally {
                    export.dropReference();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRemove() {
            ExportListener exportListener = this;
            synchronized (exportListener) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            GrpcUtil.safelyComplete(this.listener);
        }
    }

    @FunctionalInterface
    public static interface ExportErrorGrpcHandler {
        public void onError(StatusRuntimeException var1);
    }

    @FunctionalInterface
    public static interface ExportErrorHandler {
        public void onError(ExportNotification.State var1, String var2, @Nullable Exception var3, @Nullable String var4);
    }

    @AssistedFactory
    public static interface Factory {
        public SessionState create(AuthContext var1);
    }
}

