/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.google.protobuf.ByteString;
import com.google.rpc.Code;
import io.deephaven.auth.AuthContext;
import io.deephaven.auth.AuthenticationException;
import io.deephaven.csv.util.MutableObject;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.proto.backplane.grpc.CloseSessionResponse;
import io.deephaven.proto.backplane.grpc.ExportNotification;
import io.deephaven.proto.backplane.grpc.ExportNotificationRequest;
import io.deephaven.proto.backplane.grpc.ExportRequest;
import io.deephaven.proto.backplane.grpc.ExportResponse;
import io.deephaven.proto.backplane.grpc.HandshakeRequest;
import io.deephaven.proto.backplane.grpc.HandshakeResponse;
import io.deephaven.proto.backplane.grpc.ObjectServiceGrpc;
import io.deephaven.proto.backplane.grpc.PublishRequest;
import io.deephaven.proto.backplane.grpc.PublishResponse;
import io.deephaven.proto.backplane.grpc.ReleaseRequest;
import io.deephaven.proto.backplane.grpc.ReleaseResponse;
import io.deephaven.proto.backplane.grpc.SessionServiceGrpc;
import io.deephaven.proto.backplane.grpc.TerminationNotificationRequest;
import io.deephaven.proto.backplane.grpc.TerminationNotificationResponse;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.backplane.script.grpc.ConsoleServiceGrpc;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.AuthCookie;
import io.deephaven.server.session.SessionService;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketRouter;
import io.deephaven.util.SafeCloseable;
import io.grpc.Context;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.auth.AuthConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionServiceGrpcImpl
extends SessionServiceGrpc.SessionServiceImplBase {
    @Deprecated
    public static final String DEEPHAVEN_SESSION_ID = "Authorization";
    public static final Metadata.Key<String> SESSION_HEADER_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Context.Key<SessionState> SESSION_CONTEXT_KEY = Context.key((String)"Authorization");
    private static final String SERVER_CALL_ID = "SessionServiceGrpcImpl.ServerCall";
    private static final Context.Key<InterceptedCall<?, ?>> SESSION_CALL_KEY = Context.key((String)"SessionServiceGrpcImpl.ServerCall");
    private static final Logger log = LoggerFactory.getLogger(SessionServiceGrpcImpl.class);
    private final SessionService service;
    private final TicketRouter ticketRouter;

    @Inject
    public SessionServiceGrpcImpl(SessionService service, TicketRouter ticketRouter) {
        this.service = service;
        this.ticketRouter = ticketRouter;
    }

    public void newSession(@NotNull HandshakeRequest request, @NotNull StreamObserver<HandshakeResponse> responseObserver) {
        AuthContext.SuperUser authContext = new AuthContext.SuperUser();
        SessionState session = this.service.newSession((AuthContext)authContext);
        responseObserver.onNext((Object)HandshakeResponse.newBuilder().setMetadataHeader(ByteString.copyFromUtf8((String)DEEPHAVEN_SESSION_ID)).setSessionToken(session.getExpiration().getBearerTokenAsByteString()).setTokenDeadlineTimeMillis(session.getExpiration().deadlineMillis).setTokenExpirationDelayMillis(this.service.getExpirationDelayMs()).build());
        responseObserver.onCompleted();
    }

    public void refreshSessionToken(@NotNull HandshakeRequest request, @NotNull StreamObserver<HandshakeResponse> responseObserver) {
        if (request.getAuthProtocol() != 0) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Protocol version not allowed."));
            return;
        }
        SessionState session = this.service.getCurrentSession();
        SessionService.TokenExpiration expiration = this.service.refreshToken(session);
        responseObserver.onNext((Object)HandshakeResponse.newBuilder().setMetadataHeader(ByteString.copyFromUtf8((String)DEEPHAVEN_SESSION_ID)).setSessionToken(expiration.getBearerTokenAsByteString()).setTokenDeadlineTimeMillis(expiration.deadlineMillis).setTokenExpirationDelayMillis(this.service.getExpirationDelayMs()).build());
        responseObserver.onCompleted();
    }

    public void closeSession(@NotNull HandshakeRequest request, @NotNull StreamObserver<CloseSessionResponse> responseObserver) {
        if (request.getAuthProtocol() != 0) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Protocol version not allowed."));
            return;
        }
        SessionState session = this.service.getCurrentSession();
        this.service.closeSession(session);
        responseObserver.onNext((Object)CloseSessionResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void release(@NotNull ReleaseRequest request, @NotNull StreamObserver<ReleaseResponse> responseObserver) {
        SessionState session = this.service.getCurrentSession();
        if (!request.hasId()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Release ticket not supplied"));
            return;
        }
        SessionState.ExportObject export = session.getExportIfExists(request.getId(), "id");
        if (export == null) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.UNAVAILABLE, (String)"Export not yet defined"));
            return;
        }
        export.cancel();
        responseObserver.onNext((Object)ReleaseResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void exportFromTicket(@NotNull ExportRequest request, @NotNull StreamObserver<ExportResponse> responseObserver) {
        SessionState session = this.service.getCurrentSession();
        if (!request.hasSourceId()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Source ticket not supplied"));
            return;
        }
        if (!request.hasResultId()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Result ticket not supplied"));
            return;
        }
        String description = "SessionService#exportFromTicket(object=" + this.ticketRouter.getLogNameFor(request.getSourceId(), "sourceId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject source = this.ticketRouter.resolve(session, request.getSourceId(), "sourceId");
            session.newExport(request.getResultId(), "resultId").queryPerformanceRecorder(queryPerformanceRecorder).require(source).onError(responseObserver).onSuccess(ignoredResult -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)ExportResponse.getDefaultInstance())).submit(source::get);
        }
    }

    public void publishFromTicket(@NotNull PublishRequest request, @NotNull StreamObserver<PublishResponse> responseObserver) {
        SessionState session = this.service.getCurrentSession();
        if (!request.hasSourceId()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Source ticket not supplied"));
            return;
        }
        if (!request.hasResultId()) {
            responseObserver.onError((Throwable)Exceptions.statusRuntimeException((Code)Code.INVALID_ARGUMENT, (String)"Result ticket not supplied"));
            return;
        }
        String description = "SessionService#publishFromTicket(object=" + this.ticketRouter.getLogNameFor(request.getSourceId(), "sourceId") + ")";
        QueryPerformanceRecorder queryPerformanceRecorder = QueryPerformanceRecorder.newQuery((String)description, (String)session.getSessionId(), (QueryPerformanceNugget.Factory)QueryPerformanceNugget.DEFAULT_FACTORY);
        try (SafeCloseable ignored = queryPerformanceRecorder.startQuery();){
            SessionState.ExportObject source = this.ticketRouter.resolve(session, request.getSourceId(), "sourceId");
            Ticket resultId = request.getResultId();
            this.ticketRouter.publish(session, resultId, "resultId", () -> GrpcUtil.safelyOnNextAndComplete((StreamObserver)responseObserver, (Object)PublishResponse.getDefaultInstance()), SessionState.toErrorHandler(sre -> GrpcUtil.safelyError((StreamObserver)responseObserver, (StatusRuntimeException)sre)), source);
        }
    }

    public void exportNotifications(@NotNull ExportNotificationRequest request, @NotNull StreamObserver<ExportNotification> responseObserver) {
        SessionState session = this.service.getCurrentSession();
        session.addExportListener(responseObserver);
        ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> session.removeExportListener(responseObserver));
    }

    public void terminationNotification(@NotNull TerminationNotificationRequest request, @NotNull StreamObserver<TerminationNotificationResponse> responseObserver) {
        SessionState session = this.service.getCurrentSession();
        this.service.addTerminationListener(session, responseObserver);
    }

    public static void insertCallHeader(String key, String value) {
        Metadata.Key metaKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        InterceptedCall call = (InterceptedCall)((Object)SESSION_CALL_KEY.get());
        if (call == null) {
            throw new IllegalStateException("Cannot insert call header; there is no grpc call in the context");
        }
        if (call.sentHeaders) {
            throw new IllegalStateException("Cannot insert call header; headers already sent");
        }
        if (call.extraHeaders.put((Metadata.Key<String>)metaKey, value) != null) {
            log.warn().append((CharSequence)"Overwrote gRPC call header with key: ").append((CharSequence)metaKey.toString()).endl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <ReqT, RespT> void rpcWrapper(@NotNull ServerCall<ReqT, RespT> call, @NotNull Context context, @Nullable SessionState session, @NotNull SessionService.ErrorTransformer errorTransformer, @NotNull Runnable lambda) {
        Context previous = context.attach();
        try (SafeCloseable ignored1 = session == null ? null : session.getExecutionContext().open();){
            try (SafeCloseable ignored2 = LivenessScopeStack.open();){
                lambda.run();
            }
            catch (RuntimeException err) {
                SessionServiceGrpcImpl.safeClose(call, errorTransformer.transform(err));
            }
            catch (Error error) {
                SessionServiceGrpcImpl.safeClose(call, Status.INTERNAL, new Metadata(), false);
                throw error;
            }
        }
        finally {
            context.detach(previous);
        }
    }

    private static void safeClose(@NotNull ServerCall<?, ?> call, @NotNull StatusRuntimeException err) {
        Metadata metadata = Status.trailersFromThrowable((Throwable)err);
        if (metadata == null) {
            metadata = new Metadata();
        }
        SessionServiceGrpcImpl.safeClose(call, Status.fromThrowable((Throwable)err), metadata, true);
    }

    private static void safeClose(ServerCall<?, ?> call, Status status, Metadata trailers, boolean logOnError) {
        block2: {
            try {
                call.close(status, trailers);
            }
            catch (IllegalStateException e) {
                if (!logOnError || !log.isDebugEnabled()) break block2;
                log.debug().append((CharSequence)"call.close error: ").append((Throwable)e).endl();
            }
        }
    }

    public static class InterceptedCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private boolean sentHeaders = false;
        private final SessionService service;
        private final SessionState session;
        private final Map<Metadata.Key<String>, String> extraHeaders = new LinkedHashMap<Metadata.Key<String>, String>();
        private final boolean setDeephavenAuthCookie;

        private InterceptedCall(SessionService service, ServerCall<ReqT, RespT> call, @Nullable SessionState session, boolean setDeephavenAuthCookie) {
            super(Objects.requireNonNull(call));
            this.service = Objects.requireNonNull(service);
            this.session = session;
            this.setDeephavenAuthCookie = setDeephavenAuthCookie;
        }

        public void sendHeaders(Metadata headers) {
            this.sentHeaders = true;
            try {
                this.addHeaders(headers);
            }
            finally {
                super.sendHeaders(headers);
            }
        }

        public void close(Status status, Metadata trailers) {
            try {
                if (!this.sentHeaders) {
                    this.addHeaders(trailers);
                }
            }
            finally {
                super.close(status, trailers);
            }
        }

        private void addHeaders(Metadata md) {
            SessionService.TokenExpiration exp;
            this.extraHeaders.forEach((arg_0, arg_1) -> ((Metadata)md).put(arg_0, arg_1));
            if (this.session != null && (exp = this.service.refreshToken(this.session)) != null) {
                md.put(SESSION_HEADER_KEY, (Object)("Bearer " + exp.token.toString()));
                if (this.setDeephavenAuthCookie) {
                    AuthCookie.setDeephavenAuthCookie(md, exp.token);
                }
            }
        }
    }

    private static class SessionServiceCallListener<ReqT, RespT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>
    implements Closeable {
        private static final Status SESSION_CLOSED = Status.CANCELLED.withDescription("Session closed");
        private final ServerCall<ReqT, RespT> call;
        private final Context context;
        private final SessionState session;
        private final SessionService.ErrorTransformer errorTransformer;
        private final boolean autoCancelOnSessionClose;

        SessionServiceCallListener(ServerCall.Listener<ReqT> delegate, ServerCall<ReqT, RespT> call, Context context, SessionState session, SessionService.ErrorTransformer errorTransformer, boolean autoCancelOnSessionClose) {
            super(delegate);
            this.call = call;
            this.context = context;
            this.session = session;
            this.errorTransformer = errorTransformer;
            this.autoCancelOnSessionClose = autoCancelOnSessionClose;
            if (autoCancelOnSessionClose && session != null) {
                session.addOnCloseCallback(this);
            }
        }

        @Override
        public void close() {
            SessionServiceGrpcImpl.safeClose(this.call, SESSION_CLOSED, new Metadata(), false);
        }

        public void onMessage(ReqT message) {
            SessionServiceGrpcImpl.rpcWrapper(this.call, this.context, this.session, this.errorTransformer, () -> super.onMessage(message));
        }

        public void onHalfClose() {
            SessionServiceGrpcImpl.rpcWrapper(this.call, this.context, this.session, this.errorTransformer, () -> super.onHalfClose());
        }

        public void onCancel() {
            SessionServiceGrpcImpl.rpcWrapper(this.call, this.context, this.session, this.errorTransformer, () -> super.onCancel());
            if (this.autoCancelOnSessionClose && this.session != null) {
                this.session.removeOnCloseCallback(this);
            }
        }

        public void onComplete() {
            SessionServiceGrpcImpl.rpcWrapper(this.call, this.context, this.session, this.errorTransformer, () -> super.onComplete());
            if (this.autoCancelOnSessionClose && this.session != null) {
                this.session.removeOnCloseCallback(this);
            }
        }

        public void onReady() {
            SessionServiceGrpcImpl.rpcWrapper(this.call, this.context, this.session, this.errorTransformer, () -> super.onReady());
        }
    }

    @Singleton
    public static class SessionServiceInterceptor
    implements ServerInterceptor {
        private static final Status AUTHENTICATION_DETAILS_INVALID = Status.UNAUTHENTICATED.withDescription("Authentication details invalid");
        private static final Set<String> CANCEL_RPC_ON_SESSION_CLOSE = Set.of(ConsoleServiceGrpc.getSubscribeToLogsMethod().getFullMethodName(), ObjectServiceGrpc.getMessageStreamMethod().getFullMethodName());
        private final SessionService service;
        private final SessionService.ErrorTransformer errorTransformer;

        @Inject
        public SessionServiceInterceptor(SessionService service, SessionService.ErrorTransformer errorTransformer) {
            this.service = Objects.requireNonNull(service);
            this.errorTransformer = Objects.requireNonNull(errorTransformer);
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            String token;
            UUID uuid;
            SessionState session = null;
            byte[] altToken = (byte[])metadata.get(AuthConstants.TOKEN_KEY);
            if (altToken != null) {
                try {
                    session = this.service.getSessionForToken(UuidCreator.fromString((String)new String(altToken, StandardCharsets.US_ASCII)));
                }
                catch (InvalidUuidException | IllegalArgumentException throwable) {
                    // empty catch block
                }
            }
            if (session == null && (uuid = (UUID)AuthCookie.parseAuthCookie(metadata).orElse(null)) != null) {
                session = this.service.getSessionForToken(uuid);
            }
            if (session == null && (token = (String)metadata.get(SESSION_HEADER_KEY)) != null) {
                try {
                    session = this.service.getSessionForAuthToken(token);
                }
                catch (AuthenticationException e) {
                    SessionServiceGrpcImpl.safeClose(call, AUTHENTICATION_DETAILS_INVALID, new Metadata(), false);
                    return new ServerCall.Listener<ReqT>(){};
                }
            }
            InterceptedCall serverCall = new InterceptedCall(this.service, call, session, AuthCookie.hasDeephavenAuthCookieRequest(metadata));
            Context context = Context.current().withValues(SESSION_CONTEXT_KEY, (Object)session, SESSION_CALL_KEY, serverCall);
            SessionState finalSession = session;
            MutableObject listener = new MutableObject();
            SessionServiceGrpcImpl.rpcWrapper(serverCall, context, finalSession, this.errorTransformer, () -> listener.setValue(this.listener(serverCall, metadata, serverCallHandler, context, finalSession)));
            if (listener.getValue() == null) {
                return new ServerCall.Listener<ReqT>(){};
            }
            return (ServerCall.Listener)listener.getValue();
        }

        @NotNull
        private <ReqT, RespT> SessionServiceCallListener<ReqT, RespT> listener(InterceptedCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler, Context context, SessionState session) {
            return new SessionServiceCallListener<ReqT, RespT>(serverCallHandler.startCall(serverCall, metadata), serverCall, context, session, this.errorTransformer, CANCEL_RPC_ON_SESSION_CLOSE.contains(serverCall.getMethodDescriptor().getFullMethodName()));
        }
    }
}

