/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import io.deephaven.client.impl.BarrageSessionFactoryConfig;
import io.deephaven.client.impl.ClientChannelFactory;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.client.impl.FlightSessionFactoryConfig;
import io.deephaven.client.impl.SessionConfig;
import io.deephaven.client.impl.SessionFactoryConfig;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.apache.arrow.memory.BufferAllocator;

public final class SessionFactoryCreator {
    private static final SessionConfig SESSION_CONFIG_EMPTY = SessionConfig.builder().build();
    private final ScheduledExecutorService scheduler;
    private final BufferAllocator allocator;
    private final ClientChannelFactory clientChannelFactory;

    @Inject
    public SessionFactoryCreator(ScheduledExecutorService scheduler, BufferAllocator allocator, ClientChannelFactory clientChannelFactory) {
        this.scheduler = Objects.requireNonNull(scheduler);
        this.allocator = Objects.requireNonNull(allocator);
        this.clientChannelFactory = Objects.requireNonNull(clientChannelFactory);
    }

    public SessionFactoryConfig.Factory sessionFactory(ClientConfig clientConfig) {
        return SessionFactoryConfig.builder().clientConfig(clientConfig).clientChannelFactory(this.clientChannelFactory).sessionConfig(SESSION_CONFIG_EMPTY).scheduler(this.scheduler).build().factory();
    }

    public FlightSessionFactoryConfig.Factory flightFactory(ClientConfig clientConfig) {
        return FlightSessionFactoryConfig.builder().clientConfig(clientConfig).clientChannelFactory(this.clientChannelFactory).sessionConfig(SESSION_CONFIG_EMPTY).allocator(this.allocator).scheduler(this.scheduler).build().factory();
    }

    public BarrageSessionFactoryConfig.Factory barrageFactory(ClientConfig clientConfig) {
        return BarrageSessionFactoryConfig.builder().clientConfig(clientConfig).clientChannelFactory(this.clientChannelFactory).sessionConfig(SESSION_CONFIG_EMPTY).allocator(this.allocator).scheduler(this.scheduler).build().factory();
    }
}

