/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import io.deephaven.extensions.barrage.util.GrpcUtil;
import io.deephaven.server.session.SessionState;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;

public abstract class SessionCloseableObserver<T>
implements Closeable {
    protected final SessionState session;
    protected final StreamObserver<T> responseObserver;
    private boolean isClosed = false;

    public SessionCloseableObserver(SessionState session, StreamObserver<T> responseObserver) {
        this.session = session;
        this.responseObserver = responseObserver;
        session.addOnCloseCallback(this);
        ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(this::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        this.session.removeOnCloseCallback(this);
        SessionCloseableObserver sessionCloseableObserver = this;
        synchronized (sessionCloseableObserver) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.onClose();
        GrpcUtil.safelyComplete(this.responseObserver);
    }

    protected void onClose() {
    }
}

