/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import io.deephaven.server.session.PathResolver;
import java.util.Objects;
import org.apache.arrow.flight.impl.Flight;

public abstract class PathResolverPrefixedBase
implements PathResolver {
    private final String flightDescriptorRoute;

    public PathResolverPrefixedBase(String flightDescriptorRoute) {
        this.flightDescriptorRoute = Objects.requireNonNull(flightDescriptorRoute);
    }

    public final String flightDescriptorRoute() {
        return this.flightDescriptorRoute;
    }

    @Override
    public final boolean handlesPath(Flight.FlightDescriptor descriptor) {
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw new IllegalStateException("descriptor is not a path");
        }
        if (descriptor.getPathCount() == 0) {
            return false;
        }
        return this.flightDescriptorRoute.equals(descriptor.getPath(0));
    }
}

