/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.google.rpc.Code;
import io.deephaven.engine.table.Table;
import io.deephaven.proto.flight.util.FlightExportTicketHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ExportTicketHelper;
import io.deephaven.server.auth.AuthorizationProvider;
import io.deephaven.server.session.SessionState;
import io.deephaven.server.session.TicketResolverBase;
import io.deephaven.server.session.TicketRouter;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.arrow.flight.impl.Flight;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ExportTicketResolver
extends TicketResolverBase {
    @Inject
    public ExportTicketResolver(AuthorizationProvider authProvider) {
        super(authProvider, (byte)101, "export");
    }

    @Override
    public String getLogNameFor(ByteBuffer ticket, String logId) {
        return ExportTicketHelper.toReadableString((ByteBuffer)ticket, (String)logId);
    }

    @Override
    public SessionState.ExportObject<Flight.FlightInfo> flightInfoFor(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        if (session == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)("Could not resolve '" + logId + "': no exports can exist without a session to search"));
        }
        SessionState.ExportObject export = this.resolve(session, descriptor, logId);
        return session.nonExport().require(export).submit(() -> {
            if (export.get() instanceof Table) {
                return TicketRouter.getFlightInfo((Table)export.get(), descriptor, FlightExportTicketHelper.descriptorToFlightTicket((Flight.FlightDescriptor)descriptor, (String)logId));
            }
            throw Exceptions.statusRuntimeException((Code)Code.NOT_FOUND, (String)("Could not resolve '" + logId + "': flight '" + String.valueOf(descriptor) + "' not found"));
        });
    }

    @Override
    public void forAllFlightInfo(@Nullable SessionState session, Consumer<Flight.FlightInfo> visitor) {
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, ByteBuffer ticket, String logId) {
        if (session == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)("Could not resolve '" + logId + "': no exports can exist without an active session"));
        }
        return session.getExport(ExportTicketHelper.ticketToExportId((ByteBuffer)ticket, (String)logId));
    }

    @Override
    public <T> SessionState.ExportObject<T> resolve(@Nullable SessionState session, Flight.FlightDescriptor descriptor, String logId) {
        if (session == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNAUTHENTICATED, (String)("Could not resolve '" + logId + "': no exports can exist without a session to search"));
        }
        return session.getExport(FlightExportTicketHelper.descriptorToExportId((Flight.FlightDescriptor)descriptor, (String)logId));
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, ByteBuffer ticket, String logId, @Nullable Runnable onPublish) {
        SessionState.ExportBuilder toPublish = session.newExport(ExportTicketHelper.ticketToExportId((ByteBuffer)ticket, (String)logId));
        if (onPublish != null) {
            session.nonExport().require(toPublish.getExport()).submit(onPublish);
        }
        return toPublish;
    }

    @Override
    public <T> SessionState.ExportBuilder<T> publish(SessionState session, Flight.FlightDescriptor descriptor, String logId, @Nullable Runnable onPublish) {
        SessionState.ExportBuilder toPublish = session.newExport(FlightExportTicketHelper.descriptorToExportId((Flight.FlightDescriptor)descriptor, (String)logId));
        if (onPublish != null) {
            session.nonExport().require(toPublish.getExport()).submit(onPublish);
        }
        return toPublish;
    }
}

