/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.server.session.SessionListener;
import io.deephaven.server.session.SessionState;
import java.util.Collection;

public class DelegatingSessionListener
implements SessionListener {
    private static final Logger log = LoggerFactory.getLogger(DelegatingSessionListener.class);
    private final Collection<SessionListener> sessionListeners;

    public DelegatingSessionListener(Collection<SessionListener> sessionListeners) {
        this.sessionListeners = sessionListeners;
    }

    @Override
    public void onSessionCreate(SessionState session) {
        for (SessionListener listener : this.sessionListeners) {
            try {
                listener.onSessionCreate(session);
            }
            catch (Exception e) {
                log.error().append((CharSequence)"Error invoking session listener ").append((CharSequence)listener.getClass().getName()).append((Throwable)e).endl();
            }
        }
    }
}

