/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.github.f4b6a3.uuid.UuidCreator;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import io.grpc.Metadata;
import java.util.Optional;
import java.util.UUID;

final class AuthCookie {
    private static final String HEADER = "x-deephaven-auth-cookie-request";
    private static final String DEEPHAVEN_AUTH_COOKIE = "deephaven-auth-cookie";
    private static final Metadata.Key<String> REQUEST_AUTH_COOKIE_HEADER_KEY = Metadata.Key.of((String)"x-deephaven-auth-cookie-request", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SET_COOKIE = Metadata.Key.of((String)"set-cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> COOKIE = Metadata.Key.of((String)"cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    AuthCookie() {
    }

    public static boolean hasDeephavenAuthCookieRequest(Metadata md) {
        return Boolean.parseBoolean((String)md.get(REQUEST_AUTH_COOKIE_HEADER_KEY));
    }

    public static void setDeephavenAuthCookie(Metadata md, UUID token) {
        md.put(SET_COOKIE, (Object)("deephaven-auth-cookie=" + token.toString()));
    }

    public static Optional<UUID> parseAuthCookie(Metadata md) {
        UUID uuid;
        String cookie = (String)md.get(COOKIE);
        if (cookie == null) {
            return Optional.empty();
        }
        String[] split = cookie.split("=");
        if (split.length != 2 || !DEEPHAVEN_AUTH_COOKIE.equals(split[0])) {
            return Optional.empty();
        }
        try {
            uuid = UuidCreator.fromString((String)split[1]);
        }
        catch (InvalidUuidException e) {
            return Optional.empty();
        }
        return Optional.of(uuid);
    }
}

