/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.server.session;

import com.google.rpc.Code;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.server.session.ActionResolver;
import io.deephaven.server.session.SessionState;
import io.grpc.stub.StreamObserver;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.ActionType;
import org.apache.arrow.flight.Result;
import org.jetbrains.annotations.Nullable;

public final class ActionRouter {
    private final Set<ActionResolver> resolvers;

    private static boolean enabled(ActionResolver resolver) {
        String property = ActionResolver.class.getSimpleName() + "." + resolver.getClass().getSimpleName() + ".enabled";
        return Configuration.getInstance().getBooleanWithDefault(property, true);
    }

    @Inject
    public ActionRouter(Set<ActionResolver> resolvers) {
        this.resolvers = resolvers.stream().filter(ActionRouter::enabled).collect(Collectors.toSet());
    }

    public void listActions(@Nullable SessionState session, Consumer<ActionType> visitor) {
        QueryPerformanceRecorder qpr = QueryPerformanceRecorder.getInstance();
        try (QueryPerformanceNugget ignored = qpr.getNugget("listActions");){
            for (ActionResolver resolver : this.resolvers) {
                resolver.listActions(session, visitor);
            }
        }
    }

    public void doAction(@Nullable SessionState session, Action action, StreamObserver<Result> observer) {
        QueryPerformanceRecorder qpr = QueryPerformanceRecorder.getInstance();
        try (QueryPerformanceNugget ignored = qpr.getNugget(String.format("doAction:%s", action.getType()));){
            this.getResolver(action.getType()).doAction(session, action, observer);
        }
    }

    private ActionResolver getResolver(String type) {
        ActionResolver actionResolver = null;
        for (ActionResolver resolver : this.resolvers) {
            if (!resolver.handlesActionType(type)) continue;
            if (actionResolver != null) {
                throw Exceptions.statusRuntimeException((Code)Code.INTERNAL, (String)String.format("Found multiple doAction resolvers for action type '%s'", type));
            }
            actionResolver = resolver;
        }
        if (actionResolver == null) {
            throw Exceptions.statusRuntimeException((Code)Code.UNIMPLEMENTED, (String)String.format("No action resolver found for action type '%s'", type));
        }
        return actionResolver;
    }
}

